/******************************************************************
 * File automatically generated by rebuild_printer.py (v1.2.0.06) *
 ******************************************************************/
#include <stdint.h>
#include <stddef.h>
#include <string.h>
#include <stdio.h>

#include "arm_printer.h"

// conditions
#define cEQ (0b0000<<28)
#define cNE (0b0001<<28)
#define cCS (0b0010<<28)
#define cCC (0b0011<<28)
#define cMI (0b0100<<28)
#define cPL (0b0101<<28)
#define cVS (0b0110<<28)
#define cVC (0b0111<<28)
#define cHI (0b1000<<28)
#define cLS (0b1001<<28)
#define cGE (0b1010<<28)
#define cLT (0b1011<<28)
#define cGT (0b1100<<28)
#define cLE (0b1101<<28)
#define c__ (0b1110<<28)	// means all

static const char* conds[16] = {
	"EQ", "NE", "CS", "CC",
	"MI", "PL", "VS", "VC",
	"HI", "LS", "GE", "LT",
	"GT", "LE",   "", "##"
};

static const char* regname[16] = {
	"r0", "r1", "r2", "r3", "r4",
	"r5", "r6", "r7", "r8", "r9",
	"r10", "r11", "r12", "SP", "LR", "PC"
};

// Single precision are V_:_
// Double and quad precision are _:V_
// So we always use _:V_ and invert the corresponding single-precision (cleaner? code)
static const char* vecname[96] = {
	"S0",  "S2",  "S4",  "S6",  "S8", "S10", "S12", "S14",
	"S16", "S18", "S20", "S22", "S24", "S26", "S28", "S30",
	"S1",  "S3",  "S5",  "S7",  "S9", "S11", "S13", "S15",
	"S17", "S19", "S21", "S23", "S25", "S27", "S29", "S31",
	"D0", "D1", "D2", "D3", "D4", "D5", "D6", "D7",
	"D8", "D9", "D10", "D11", "D12", "D13", "D14", "D15",
	"D16", "D17", "D18", "D19", "D20", "D21", "D22", "D23",
	"D24", "D25", "D26", "D27", "D28", "D29", "D30", "D31",
	"Q0", "!!!", "Q1", "!!!", "Q2", "!!!", "Q3", "!!!",
	"Q4", "!!!", "Q5", "!!!", "Q6", "!!!", "Q7", "!!!",
	"Q8", "!!!", "Q9", "!!!", "Q10", "!!!", "Q11", "!!!",
	"Q12", "!!!", "Q13", "!!!", "Q14", "!!!", "Q15", "!!!"
};

static const char* dts[16] = {
	"S8", "S16", "S32", "S64",
	"U8", "U16", "U32", "U64",
	"I8", "I16", "I32", "I64",
	"F8", "F16", "F32", "F64"
};

static const char* shift_type[4] = {
	"lsl ", "lsr ", "asr ", "ror "
};

const char* print_shift(int shift, int comma) {
	static __thread char ret[20];
	ret[0] = '\0';
	
	int sh_op = (shift >> 1) & 3;
	if(shift & 1) {
		int rs = shift >> 4;
		sprintf(ret, "%s%s%s", (comma ? ", " : ""), shift_type[sh_op], regname[rs]);
	} else {
		uint8_t amount = shift >> 3;
		if (!amount) {
			switch (sh_op) {
			case 0b00:
				break;
			case 0b01:
			case 0b10:
				sprintf(ret, "%s%s#32", (comma ? ", " : ""), shift_type[sh_op]);
				break;
			case 0b11:
				sprintf(ret, "%srrx", (comma ? ", " : ""));
				break;
			}
		} else {
			sprintf(ret, "%s%s#%u", (comma ? ", " : ""), shift_type[sh_op], amount);
		}
	}
	return ret;
}

#define print_modified_imm_ARM(imm12) (((imm12 & 0xFF) >> (2*(imm12 >> 8))) | ((imm12 & 0xFF) << (32 - 2*(imm12 >> 8))))

const char* print_register_list(int list, int size) {
	int last = -2;
	int cnt = 0;
	static __thread char ret[68];
	
	ret[0] = '{';
	ret[1] = '\0';
	for (int i = 0; i < size; ++i) {
		if (list & (1 << i)) {
			if (last >= 0) {
				++cnt;
			} else {
				if (last == -1)
					strcat(ret, ", ");
				strcat(ret, regname[i]);
				last = i;
			}
		} else {
			if (cnt) {
				strcat(ret, "-");
				strcat(ret, regname[i - 1]);
			}
			if (last != -2) last = -1;
			cnt = 0;
		}
	}
	if (cnt) {
		strcat(ret, "-");
		strcat(ret, regname[size - 1]);
	}
	strcat(ret, "}");
	
	return ret;
}

const char* print_register_list_fpu(uint8_t start, uint8_t size, uint8_t double_prec) {
	static __thread char ret[68];
	
	// Assume VFPSmallRegisterBank(), so no D16 and no S32 (and above)
	if (start + (double_prec + 1) * size > 32) {
		return "!!!";
	}
	if (size == 0) {
		return "!!!";
	}
	if (double_prec && (size % 2 == 1)) {
		strcpy(ret, "!! {");
	} else {
		ret[0] = '{';
		ret[1] = '\0';
	}
	
	char regChr;
	if (double_prec) {
		regChr = 'D';
		size /= 2;
	} else {
		regChr = 'S';
		start = (start >> 4) + ((start & 0xF) << 1);
	}
	
	char tmp[7];
	for (int cur = start; cur < start + size - 1; ++cur) {
		sprintf(tmp, "%c%d, ", regChr, cur);
		strcat(ret, tmp);
	}
	sprintf(tmp, "%c%d}", regChr, start + size - 1);
	strcat(ret, tmp);
	
	return ret;
}

static const char* _print_modified_imm_I64_bytes[2] = {"00", "FF"};

const char* print_modified_imm_NEON(int op_cmode, int imm) {
	static __thread char ret[34] = "???\0-"; // [dt: 4][imm: 30]
	
	strcpy(&ret[4], "UNPREDICTABLE");
	
	switch (op_cmode) {
	case 0b00000: // VMOV.I32
	case 0b00001: // VORR.I32
	case 0b10000: // VMVN.I32
	case 0b10001: // VBIC.I32
		strcpy(ret, "I32");
		sprintf(&ret[4], "0x%02X", imm);
		break;
	case 0b00010: // VMOV.I32
	case 0b00011: // VORR.I32
	case 0b10010: // VMVN.I32
	case 0b10011: // VBIC.I32
		if (imm) {
			strcpy(ret, "I32");
			sprintf(&ret[4], "0x%02X00", imm);
		}
		break;
	case 0b00100: // VMOV.I32
	case 0b00101: // VORR.I32
	case 0b10100: // VMVN.I32
	case 0b10101: // VBIC.I32
		if (imm) {
			strcpy(ret, "I32");
			sprintf(&ret[4], "0x%02X0000", imm);
		}
		break;
	case 0b00110: // VMOV.I32
	case 0b00111: // VORR.I32
	case 0b10110: // VMVN.I32
	case 0b10111: // VBIC.I32
		if (imm) {
			strcpy(ret, "I32");
			sprintf(&ret[4], "0x%02X000000", imm);
		}
		break;
	case 0b01000: // VMOV.I16
	case 0b01001: // VORR.I16
	case 0b11000: // VMVN.I16
	case 0b11001: // VBIC.I16
		strcpy(ret, "I16");
		sprintf(&ret[4], "0x%02X", imm);
		break;
	case 0b01010: // VMOV.I16
	case 0b01011: // VORR.I16
	case 0b11010: // VMVN.I16
	case 0b11011: // VBIC.I16
		if (imm) {
			strcpy(ret, "I16");
			sprintf(&ret[4], "0x%02X00", imm);
		}
		break;
	case 0b01100: // VMOV.I32
	case 0b11100: // VMVN.I32
		if (imm) {
			strcpy(ret, "I32");
			sprintf(&ret[4], "0x%02XFF", imm);
		}
		break;
	case 0b01101: // VMOV.I32
	case 0b11101: // VMVN.I32
		if (imm) {
			strcpy(ret, "I32");
			sprintf(&ret[4], "0x%02XFFFF", imm);
		}
		break;
	case 0b01110: // VMOV.I8
		strcpy(ret, "I8");
		sprintf(&ret[4], "0x%02X", imm);
		break;
	case 0b01111: // VMOV.F32
		strcpy(ret, "F32");
		sprintf(&ret[4], "%e", (imm & 0x80 ? -1 : 1) * (1 << (((imm >> 4) & 0x7) ^ 0b100)) * (float) (16 + (imm & 0xF)) / 128.);
		break;
	case 0b11110: // VMOV.I64
		{
			strcpy(ret, "I64");
			sprintf(&ret[4], "#0x%s%s%s%s%s%s%s%s",
				_print_modified_imm_I64_bytes[(imm >> 7) & 1], _print_modified_imm_I64_bytes[(imm >> 6) & 1],
				_print_modified_imm_I64_bytes[(imm >> 5) & 1], _print_modified_imm_I64_bytes[(imm >> 4) & 1],
				_print_modified_imm_I64_bytes[(imm >> 3) & 1], _print_modified_imm_I64_bytes[(imm >> 2) & 1],
				_print_modified_imm_I64_bytes[(imm >> 1) & 1], _print_modified_imm_I64_bytes[(imm >> 0) & 1]);
		}
		break;
	case 0b11111: // V???.-
	default:
		strcpy(ret, "-");
		strcpy(&ret[4], "UNDEFINED");
		break;
	}
	
	return ret;
}

const char* arm_print(uint32_t opcode) {
	static __thread char ret[100];
	memset(ret, 0, sizeof(ret));
	
	if ((opcode & 0xFFF100F0) == 0xF1010000) {
		int param = (opcode >> 9) & 0x1;
		
		sprintf(ret, "SETEND %cE", param ? 'B' : 'L');
	} else if ((opcode & 0xFE800D10) == 0xF2000000) {
		int op = (opcode >> 9) & 1;
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VH%s.%s %s, %s, %s", (op ? "SUB" : "ADD"), dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000010) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQADD.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000100) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRHADD.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF2000110) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VAND %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF2100110) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VBIC %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF2200110) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* op;
		if (m == n) {
			op = "MOV";
		} else {
			op = "ORR";
		}
		char lastop[6];
		if (m == n) {
			lastop[0] = '\0';
		} else {
			sprintf(lastop, ", %s", vecname[(q << 5) + 0x20 + n]);
		}
		
		sprintf(ret, "V%s %s, %s%s", op, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], lastop);
	} else if ((opcode & 0xFFB00F10) == 0xF2300110) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VORN %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF800F10) == 0xF3000110) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		int param = (opcode >> 20) & 0x3;
		
		const char* op;
		if (param == 0b00) {
			op = "EOR";
		} else if (param == 0b01) {
			op = "BSL";
		} else if (param == 0b10) {
			op = "BIT";
		} else {
			op = "BIF";
		}
		
		sprintf(ret, "V%s %s, %s, %s", op, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000210) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQSUB.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F00) == 0xF2000300) {
		int op = (opcode >> 4) & 1;
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* strict;
		if (op == 0) {
			strict = "T";
		} else {
			strict = "E";
		}
		
		sprintf(ret, "VCG%s.%s %s, %s, %s", strict, dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000400) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSHL.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], vecname[(q << 5) + 0x20 + n]);
	} else if ((opcode & 0xFE800F10) == 0xF2000410) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQSHL.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], vecname[(q << 5) + 0x20 + n]);
	} else if ((opcode & 0xFE800F10) == 0xF2000500) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRSHL.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], vecname[(q << 5) + 0x20 + n]);
	} else if ((opcode & 0xFE800F10) == 0xF2000510) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQRSHL.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], vecname[(q << 5) + 0x20 + n]);
	} else if ((opcode & 0xFE800F00) == 0xF2000600) {
		int op = (opcode >> 4) & 1;
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* opname;
		if (op == 0) {
			opname = "MAX";
		} else {
			opname = "MIN";
		}
		
		sprintf(ret, "V%s.%s %s, %s, %s", opname, dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000700) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABD.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000710) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABA.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000800) {
		int op = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* opname;
		if (op == 0) {
			opname = "ADD";
		} else {
			opname = "SUB";
		}
		
		sprintf(ret, "V%s.%s %s, %s, %s", opname, dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF800F10) == 0xF2000810) {
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VTST.%s %s, %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF800F10) == 0xF3000810) {
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCEQ.%s %s, %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000900) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		size = 8 << size;
		
		sprintf(ret, "VML%s.I%d %s, %s, %s", (u ? "S" : "A"), size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2000910) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMUL.%s %s, %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800F00) == 0xF2000A00) {
		int op = (opcode >> 4) & 1;
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* opname;
		if (op == 0) {
			opname = "MAX";
		} else {
			opname = "MIN";
		}
		
		sprintf(ret, "VP%s.%s %s, %s, %s", opname, dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF800F10) == 0xF2000B00) {
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQDMULH.%s %s, %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF800F10) == 0xF3000B00) {
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQRDMULH.%s %s, %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF800F50) == 0xF2000B10) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VPADD.%s %s, %s, %s", dts[size], vecname[0x20 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF2000C10) {
		int u = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* y;
		if (u == 0) {
			y = "A";
		} else {
			y = "S";
		}
		
		sprintf(ret, "VFM%s.F32 %s, %s, %s", y, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF2000D00) {
		int u = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* op;
		if (u == 0) {
			op = "ADD";
		} else {
			op = "SUB";
		}
		
		sprintf(ret, "V%s.F32 %s, %s, %s", op, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F50) == 0xF3000D00) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VPADD.F32 %s, %s, %s", vecname[0x20 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF3200D00) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABD.F32 %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF2000D10) {
		int op = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VML%s.F32 %s, %s, %s", (op ? "S" : "A"), vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF3000D10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMUL.F32 %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF2000E00) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCEQ.F32 %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF3000E00) {
		int op = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* strict;
		if (op == 1) {
			strict = "T";
		} else {
			strict = "E";
		}
		
		sprintf(ret, "VCG%s.F32 %s, %s, %s", strict, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF3000E10) {
		int op = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* strict;
		if (op == 1) {
			strict = "T";
		} else {
			strict = "E";
		}
		
		sprintf(ret, "VACG%s.F32 %s, %s, %s", strict, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF2000F00) {
		int op = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* opname;
		if (op == 0) {
			opname = "MAX";
		} else {
			opname = "MIN";
		}
		
		sprintf(ret, "V%s.F32 %s, %s, %s", opname, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFF900F10) == 0xF3000F00) {
		int op = (opcode >> 21) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		const char* opname;
		if (op == 0) {
			opname = "MAX";
		} else {
			opname = "MIN";
		}
		
		sprintf(ret, "VP%s.F32 %s, %s, %s", opname, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF2000F10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRECPS.F32 %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00F10) == 0xF2200F10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRSQRTS.F32 %s, %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFE800000) == 0xF2000000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFEB809B0) == 0xF2800010) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMOV.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB809B0) == 0xF2800110) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VORR.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80DB0) == 0xF2800810) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMOV.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80DB0) == 0xF2800910) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VORR.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80CB0) == 0xF2800C10) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMOV.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB809B0) == 0xF2800030) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMVN.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB809B0) == 0xF2800130) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VBIC.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80DB0) == 0xF2800830) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMVN.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80DB0) == 0xF2800930) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "BIC.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80EB0) == 0xF2800C30) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMVN.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80FB0) == 0xF2800E30) {
		int op = (opcode >> 5) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int cmode = (opcode >> 8) & 0xF;
		uint8_t imm8 = (((opcode >> 24) & 0x1) << 7) | (((opcode >> 16) & 0x7) << 4) | (opcode & 0xF);
		const char* decodedImm = print_modified_imm_NEON((op << 4) + cmode, imm8);
		
		sprintf(ret, "VMOV.%s %s, #%s", decodedImm, vecname[(q << 5) + 0x20 + d], decodedImm + 4);
	} else if ((opcode & 0xFEB80090) == 0xF2800010) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFBF0FD0) == 0xF2880A10) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVL.S8 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFFBF0FD0) == 0xF2900A10) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVL.S16 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFFBF0FD0) == 0xF2A00A10) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVL.S32 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFFBF0FD0) == 0xF3880A10) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVL.U8 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFFBF0FD0) == 0xF3900A10) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVL.U16 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFFBF0FD0) == 0xF3A00A10) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVL.U32 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFE800F10) == 0xF2800010) {
		int u = (opcode >> 24) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = 64 - imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VSHR.%s %s, %s, #%d", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800F10) == 0xF2800110) {
		int u = (opcode >> 24) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = 64 - imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VSRA.%s %s, %s, #%d", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800F10) == 0xF2800210) {
		int u = (opcode >> 24) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = 64 - imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VRSHR.%s %s, %s, #%d", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800F10) == 0xF2800310) {
		int u = (opcode >> 24) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = 64 - imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VRSRA.%s %s, %s, #%d", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFF800F10) == 0xF3800410) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = 64 - imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VSRI.%d %s, %s, #%d", 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFF800F10) == 0xF2800510) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = imm6 - 32;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = imm6 - 16;
			size = 1;
		} else {
			decodedImm = imm6 - 8;
		}
		
		sprintf(ret, "VSHL.I%d %s, %s, #%d", 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFF800F10) == 0xF3800510) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = imm6 - 32;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = imm6 - 16;
			size = 1;
		} else {
			decodedImm = imm6 - 8;
		}
		
		sprintf(ret, "VSLI.%d %s, %s, #%d", 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800E10) == 0xF2800610) {
		int op = (opcode >> 8) & 1;
		int u = (opcode >> 24) & 1;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t l = (opcode >> 7) & 0x1;
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (l == 1) {
			decodedImm = imm6;
			size = 3;
		} else if (imm6 & 0x20) {
			decodedImm = imm6 - 32;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = imm6 - 16;
			size = 1;
		} else {
			decodedImm = imm6 - 8;
		}
		
		sprintf(ret, "VQSHL%s.%s %s, %s, #%d", ((u & op) ? "U" : ""), dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], decodedImm);
	} else if ((opcode & 0xFF800FD0) == 0xF2800810) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		++size;
		
		sprintf(ret, "VSHRN.I%d %s, %s, #%d", 8 << size, vecname[0x20 + d], vecname[0x40 + m], decodedImm);
	} else if ((opcode & 0xFF800FD0) == 0xF2800850) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VRSHRN.I%d %s, %s, #%d", 8 << size, vecname[0x20 + d], vecname[0x40 + m], decodedImm);
	} else if ((opcode & 0xFE800ED0) == 0xF2800810) {
		int op = (opcode >> 8) & 1;
		int u = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VQSHR%sN.%s %s, %s, #%d", ((u & op) ? "U" : ""), dts[(u << 2) + size], vecname[0x20 + d], vecname[0x40 + m], decodedImm);
	} else if ((opcode & 0xFE800ED0) == 0xF2800850) {
		int op = (opcode >> 8) & 1;
		int u = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (imm6 & 0x20) {
			decodedImm = 64 - imm6;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = 32 - imm6;
			size = 1;
		} else {
			decodedImm = 16 - imm6;
		}
		
		sprintf(ret, "VQRSHR%sN.%s %s, %s, #%d", ((u & op) ? "U" : ""), dts[(u << 2) + size], vecname[0x20 + d], vecname[0x40 + m], decodedImm);
	} else if ((opcode & 0xFFB30FD0) == 0xF3B20310) {
		int size = (opcode >> 18) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSHLL.%s %s, %s, #%d", dts[size], vecname[0x40 + d], vecname[0x20 + m], 8 << size);
	} else if ((opcode & 0xFE800FD0) == 0xF2800A10) {
		int u = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (imm6 & 0x20) {
			decodedImm = imm6 - 32;
			size = 2;
		} else if (imm6 & 0x10) {
			decodedImm = imm6 - 16;
			size = 1;
		} else {
			decodedImm = imm6 - 8;
		}
		
		sprintf(ret, "VSHLL.%s %s, %s, #%d", dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFEA00E90) == 0xF2800E10) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFF800F90) == 0xF2800E10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		
		sprintf(ret, "VCVT.F32.S32 %s, %s, #%d", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], 64 - imm6);
	} else if ((opcode & 0xFF800F90) == 0xF2800F10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		
		sprintf(ret, "VCVT.S32.F32 %s, %s, #%d", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], 64 - imm6);
	} else if ((opcode & 0xFF800F90) == 0xF3800E10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		
		sprintf(ret, "VCVT.F32.U32 %s, %s, #%d", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], 64 - imm6);
	} else if ((opcode & 0xFF800F90) == 0xF3800F10) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm6 = (opcode >> 16) & 0x3F;
		
		sprintf(ret, "VCVT.U32.F32 %s, %s, #%d", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m], 64 - imm6);
	} else if ((opcode & 0xFE800010) == 0xF2800010) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB00010) == 0xF2B00000) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm4 = (opcode >> 8) & 0xF;
		
		sprintf(ret, "VEXT.8 %s, %s, %s, #%d", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[(q << 5) + 0x20 + m], imm4);
	} else if ((opcode & 0xFFBF0E10) == 0xF3BC0000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFBF0F10) == 0xF3B80100) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFBF0E90) == 0xF3B80080) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFBF0F10) == 0xF3B40100) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFBF0F90) == 0xF3B00180) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB30E10) == 0xF3B00000) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		int param = (opcode >> 7) & 0x3;
		
		sprintf(ret, "VREV%d.%d %s, %s", 64 >> param, 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F10) == 0xF3B00200) {
		int u = (opcode >> 7) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VPADDL.%s %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B00400) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCLS.%s %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B00480) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCLZ.%s %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3B00500) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCNT.8 %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3B00580) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMVN %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F10) == 0xF3B00600) {
		int u = (opcode >> 7) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VPADAL.%s %s, %s", dts[(u << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B00700) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQABS.%s %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B00780) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQNEG.%s %s, %s", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10000) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCGT.%s %s, %s, #0", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10080) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCGE.%s %s, %s, #0", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10100) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCEQ.%s %s, %s, #0", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10180) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCLE.%s %s, %s, #0", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10200) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCLT.%s %s, %s, #0", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10300) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABS.%s %s, %s", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30B90) == 0xF3B10380) {
		int f = (opcode >> 10) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VNEG.%s %s, %s", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3B20000) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSWP %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B20080) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VTRN.%d %s, %s", 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B20100) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VUZP.%d %s, %s", 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B20180) {
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VZIP.%d %s, %s", 8 << size, vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30FD0) == 0xF3B20200) {
		int size = (opcode >> 18) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOVN.%s %s, %s", dts[size], vecname[0x20 + d], vecname[0x40 + m]);
	} else if ((opcode & 0xFFB30FD0) == 0xF3B20240) {
		int size = (opcode >> 18) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQMOVUN.S%d %s, %s", 16 << size, vecname[0x20 + d], vecname[0x40 + m]);
	} else if ((opcode & 0xFFB30F90) == 0xF3B20280) {
		int u = (opcode >> 6) & 1;
		int size = (opcode >> 18) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		++size;
		
		sprintf(ret, "VQMOVN.%s %s, %s", dts[(u << 2) + size], vecname[0x20 + d], vecname[0x40 + m]);
	} else if ((opcode & 0xFFB30FD0) == 0xF3B20300) {
		int size = (opcode >> 18) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSHLL.I%d %s, %s, #%d", 8 << size, vecname[0x40 + d], vecname[0x20 + m], 8 << size);
	} else if ((opcode & 0xFFBF0FD0) == 0xF3B60600) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT.F16.F32 %s, %s", vecname[0x20 + d], vecname[0x40 + m]);
	} else if ((opcode & 0xFFBF0FD0) == 0xF3B60700) {
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT.F32.F16 %s, %s", vecname[0x40 + d], vecname[0x20 + m]);
	} else if ((opcode & 0xFFB30E90) == 0xF3B30400) {
		int f = (opcode >> 8) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRECPE.%s %s, %s", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB30E90) == 0xF3B30480) {
		int f = (opcode >> 8) & 1;
		int size = (opcode >> 18) & 0x3;
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRSQRTE.%s %s, %s", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3BB0600) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT.F32.S32 %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3BB0680) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT.S32.F32 %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3BB0700) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT.F32.U32 %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFBF0F90) == 0xF3BB0780) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT.U32.F32 %s, %s", vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + m]);
	} else if ((opcode & 0xFFB00810) == 0xF3B00000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB00C10) == 0xF3B00800) {
		int op = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		int param = (opcode >> 8) & 0x3;
		
		char list[10];
		if (param == 0b00) {
			sprintf(list, "{%s}", vecname[0x20 + n]);
		} else {
			sprintf(list, "{%s-%s}", vecname[0x20 + n], vecname[0x20 + n + param]);
		}
		
		sprintf(ret, "VTB%s.8 %s, %s, %s", (op ? "X" : "L"), vecname[0x20 + d], list, vecname[0x20 + m]);
	} else if ((opcode & 0xFFB00F90) == 0xF3B00C00) {
		int q = (opcode >> 6) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		uint8_t imm4 = (opcode >> 16) & 0xF;
		uint8_t decodedImm = 0;
		uint8_t size = 0;
		if (imm4 & 0b0001) {
			decodedImm = imm4 >> 1;
			size = 8;
		} else if (imm4 & 0b0011) {
			decodedImm = imm4 >> 2;
			size = 16;
		} else if (imm4 & 0b0111) {
			decodedImm = imm4 >> 3;
			size = 32;
		}
		
		sprintf(ret, "VDUP.%d %s, %s[%d]", size, vecname[(q << 5) + 0x20 + d], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFEB00050) == 0xF2B00000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFE800E50) == 0xF2800000) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 8) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VADD%s.%s %s, %s, %s", (q ? "W" : "L"), dts[(u << 2) + size], vecname[0x40 + d], vecname[(q << 5) + 0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFE800E50) == 0xF2800200) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 8) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSUB%s.%s %s, %s, %s", (q ? "W" : "L"), dts[(u << 2) + size], vecname[0x40 + d], vecname[(q << 5) + 0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFF800F50) == 0xF2800400) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		size = 16 << size;
		
		sprintf(ret, "VADDHN.I%d %s, %s, %s", size, vecname[0x20 + d], vecname[0x40 + n], vecname[0x40 + m]);
	} else if ((opcode & 0xFF800F50) == 0xF3800400) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRADDHN.%s %s, %s, %s", dts[size], vecname[0x20 + d], vecname[0x40 + n], vecname[0x40 + m]);
	} else if ((opcode & 0xFE800F50) == 0xF2800500) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABAL.%s %s, %s, %s", dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFF800F50) == 0xF2800600) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSUBHN.%s %s, %s, %s", dts[size], vecname[0x20 + d], vecname[0x40 + n], vecname[0x40 + m]);
	} else if ((opcode & 0xFF800F50) == 0xF3800600) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VRSUBHN.%s %s, %s, %s", dts[size], vecname[0x20 + d], vecname[0x40 + n], vecname[0x40 + m]);
	} else if ((opcode & 0xFE800F50) == 0xF2800700) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABDL.%s %s, %s, %s", dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFE800D50) == 0xF2800800) {
		int op = (opcode >> 9) & 1;
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VML%sL.%s %s, %s, %s", (op ? "S" : "A"), dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFF800D50) == 0xF2800900) {
		int op = (opcode >> 9) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQDML%sL.%s %s, %s, %s", (op ? "S" : "A"), dts[size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFE800F50) == 0xF2800C00) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMULL.%s %s, %s, %s", dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFF800F50) == 0xF2800D00) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VQDMULL.%s %s, %s, %s", dts[size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFFB00F50) == 0xF2800E00) {
		int u = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		uint8_t size = 0;
		
		sprintf(ret, "VMULL.%s %s, %s, %s", dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m]);
	} else if ((opcode & 0xFE800050) == 0xF2800000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFE800A50) == 0xF2800040) {
		int op = (opcode >> 10) & 1;
		int f = (opcode >> 8) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VML%s.%s %s, %s, %s[%d]", (op ? "S" : "A"), dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800B50) == 0xF2800240) {
		int op = (opcode >> 10) & 1;
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VML%sL.%s %s, %s, %s[%d]", (op ? "S" : "A"), dts[(u << 2) + size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFF800B50) == 0xF2800340) {
		int op = (opcode >> 10) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VQDML%sL.%s %s, %s, %s[%d]", (op ? "S" : "A"), dts[size], vecname[0x40 + d], vecname[0x20 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800E50) == 0xF2800840) {
		int f = (opcode >> 8) & 1;
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VMUL.%s %s, %s, %s[%d]", dts[0x8 + (f << 2) + size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800F50) == 0xF2800A40) {
		int u = (opcode >> 24) & 1;
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VMULL.%s %s, %s, %s[%d]", dts[(u << 2) + size], vecname[0x40 + d], vecname[0x40 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFF800F50) == 0xF2800B40) {
		int size = (opcode >> 20) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VQDMULL.%s %s, %s, %s[%d]", dts[size], vecname[0x40 + d], vecname[0x40 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800F50) == 0xF2800C40) {
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VQDMULH.%s %s, %s, %s[%d]", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800F50) == 0xF2800D40) {
		int size = (opcode >> 20) & 0x3;
		int q = (opcode >> 24) & 1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		unsigned int decodedImm;
		if (size == 0b01) {
			decodedImm = m >> 3; m &= 0x7;
		} else if (size == 0b10) {
			decodedImm = m >> 4; m &= 0xF;
		} else {
			decodedImm = m >> 5; m = 0x21;
		}
		
		sprintf(ret, "VQRDMULH.%s %s, %s, %s[%d]", dts[size], vecname[(q << 5) + 0x20 + d], vecname[(q << 5) + 0x20 + n], vecname[0x20 + m], decodedImm);
	} else if ((opcode & 0xFE800050) == 0xF2800000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB00F0F) == 0xF400000D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST4.%d {%s, %s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400000F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST4.%d {%s, %s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000000) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST4.%d {%s, %s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], vecname[0x23 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400010D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST4.%d {%s, %s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], vecname[0x26 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400010F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST4.%d {%s, %s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], vecname[0x26 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000100) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST4.%d {%s, %s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], vecname[0x26 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400020D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s-%s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400020F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s-%s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000200) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s-%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400030D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s-%s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400030F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s-%s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000300) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s-%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400040D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VST3.%d {%s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400040F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VST3.%d {%s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000400) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VST3.%d {%s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400050D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VST3.%d {%s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400050F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VST3.%d {%s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000500) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VST3.%d {%s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400060D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s-%s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400060F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s-%s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000600) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s-%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400070D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s}, [%s%s]!", 8 << size, vecname[0x20 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400070F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s}, [%s%s]", 8 << size, vecname[0x20 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000700) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400080D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400080F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000800) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF400090D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF400090F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000900) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST2.%d {%s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF4000A0D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF4000A0F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4000A00) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VST1.%d {%s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420000D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD4.%d {%s, %s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420000F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD4.%d {%s, %s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200000) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD4.%d {%s, %s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], vecname[0x23 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420010D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD4.%d {%s, %s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], vecname[0x26 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420010F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD4.%d {%s, %s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], vecname[0x26 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200100) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD4.%d {%s, %s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], vecname[0x26 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420020D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s-%s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420020F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s-%s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200200) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s-%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420030D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s-%s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420030F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s-%s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200300) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s-%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x23 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420040D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VLD3.%d {%s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420040F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VLD3.%d {%s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200400) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VLD3.%d {%s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], vecname[0x22 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420050D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VLD3.%d {%s, %s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420050F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VLD3.%d {%s, %s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200500) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[4];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 63 + param);
		}
		
		sprintf(ret, "VLD3.%d {%s, %s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], vecname[0x24 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420060D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s-%s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420060F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s-%s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200600) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s-%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420070D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s}, [%s%s]!", 8 << size, vecname[0x20 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420070F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s}, [%s%s]", 8 << size, vecname[0x20 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200700) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s}, [%s%s], %s", 8 << size, vecname[0x20 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420080D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420080F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200800) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF420090D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF420090F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200900) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD2.%d {%s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x22 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF4200A0D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s, %s}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF4200A0F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s, %s}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4200A00) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x3;
		
		char align[5];
		if (param == 0b00) {
			align[0] = '\0';
		} else {
			sprintf(align, ":%d", 32 << param);
		}
		
		sprintf(ret, "VLD1.%d {%s, %s}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00C00) == 0xF4800C00) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB0030F) == 0xF480000D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = (2 << size) - 1;
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == param>>1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VST1.%d {%s[%d]}, [%s%s]!", 8 << size, vecname[0x20 + d], x, regname[rn], align);
	} else if ((opcode & 0xFFB0030F) == 0xF480000F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = (2 << size) - 1;
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == param>>1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VST1.%d {%s[%d]}, [%s%s]", 8 << size, vecname[0x20 + d], x, regname[rn], align);
	} else if ((opcode & 0xFFB00300) == 0xF4800000) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = (2 << size) - 1;
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == param>>1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VST1.%d {%s[%d]}, [%s%s], %s", 8 << size, vecname[0x20 + d], x, regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF480010D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VST2.%d {%s[%d], %s[%d]}, [%s%s]!", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB0030F) == 0xF480010F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VST2.%d {%s[%d], %s[%d]}, [%s%s]", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB00300) == 0xF4800100) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VST2.%d {%s[%d], %s[%d]}, [%s%s], %s", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF480020D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = param & (1 << size);
		uint8_t spacing;
		if (temp == 0) {
			spacing = 0;
		} else {
			spacing = 1;
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VST3.%d {%s[%d], %s[%d], %s[%d]}, [%s]!", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, regname[rn]);
	} else if ((opcode & 0xFFB0030F) == 0xF480020F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = param & (1 << size);
		uint8_t spacing;
		if (temp == 0) {
			spacing = 0;
		} else {
			spacing = 1;
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VST3.%d {%s[%d], %s[%d], %s[%d]}, [%s]", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, regname[rn]);
	} else if ((opcode & 0xFFB00300) == 0xF4800200) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = param & (1 << size);
		uint8_t spacing;
		if (temp == 0) {
			spacing = 0;
		} else {
			spacing = 1;
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VST3.%d {%s[%d], %s[%d], %s[%d]}, [%s], %s", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, regname[rn], regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF480030D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[6];
		if (temp2 == 0b0) {
			align[0] = '\0';
		} else if (temp2 == 0b1) {
			sprintf(align, ":%d", (size ? 64 : 32));
		} else if (temp2 == 0b10) {
			sprintf(align, ":128");
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VST4.%d {%s[%d], %s[%d], %s[%d], %s[%d]}, [%s%s]!", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, vecname[0x23 + d + 3*spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB0030F) == 0xF480030F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[6];
		if (temp2 == 0b0) {
			align[0] = '\0';
		} else if (temp2 == 0b1) {
			sprintf(align, ":%d", (size ? 64 : 32));
		} else if (temp2 == 0b10) {
			sprintf(align, ":128");
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VST4.%d {%s[%d], %s[%d], %s[%d], %s[%d]}, [%s%s]", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, vecname[0x23 + d + 3*spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB00300) == 0xF4800300) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[6];
		if (temp2 == 0b0) {
			align[0] = '\0';
		} else if (temp2 == 0b1) {
			sprintf(align, ":%d", (size ? 64 : 32));
		} else if (temp2 == 0b10) {
			sprintf(align, ":128");
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VST4.%d {%s[%d], %s[%d], %s[%d], %s[%d]}, [%s%s], %s", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, vecname[0x23 + d + 3*spacing], x, regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00CC0) == 0xF4A00CC0) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB00CD0) == 0xF4A00C10) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB00F10) == 0xF4A00E10) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFFB00F2F) == 0xF4A00C0D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x1;
		
		char align[4];
		if (param == 1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD1.%d {%s[]}, [%s%s]!", 8 << size, vecname[0x20 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F2F) == 0xF4A00C0F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x1;
		
		char align[4];
		if (param == 1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD1.%d {%s[]}, [%s%s]", 8 << size, vecname[0x20 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F20) == 0xF4A00C00) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x1;
		
		char align[4];
		if (param == 1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD1.%d {%s[]}, [%s%s], %s", 8 << size, vecname[0x20 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F2F) == 0xF4A00C2D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x1;
		
		char align[4];
		if (param == 1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD1.%d {%s[], %s[]}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F2F) == 0xF4A00C2F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0x1;
		
		char align[4];
		if (param == 1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD1.%d {%s[], %s[]}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F20) == 0xF4A00C20) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0x1;
		
		char align[4];
		if (param == 1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD1.%d {%s[], %s[]}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0000D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = (2 << size) - 1;
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == param>>1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VLD1.%d {%s[%d]}, [%s%s]!", 8 << size, vecname[0x20 + d], x, regname[rn], align);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0000F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = (2 << size) - 1;
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == param>>1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VLD1.%d {%s[%d]}, [%s%s]", 8 << size, vecname[0x20 + d], x, regname[rn], align);
	} else if ((opcode & 0xFFB00300) == 0xF4A00000) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = (2 << size) - 1;
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == param>>1) {
			sprintf(align, ":%d", 8 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VLD1.%d {%s[%d]}, [%s%s], %s", 8 << size, vecname[0x20 + d], x, regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF4A00D0D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		char align[5];
		if (param2_1 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD2.%d {%s[], %s[]}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF4A00D0F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		char align[5];
		if (param2_1 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD2.%d {%s[], %s[]}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4A00D00) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		char align[5];
		if (param2_1 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD2.%d {%s[], %s[]}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0010D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VLD2.%d {%s[%d], %s[%d]}, [%s%s]!", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0010F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VLD2.%d {%s[%d], %s[%d]}, [%s%s]", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB00300) == 0xF4A00100) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[5];
		if (temp2 == 0) {
			align[0] = '\0';
		} else if (temp2 == 1) {
			sprintf(align, ":%d", 16 << size);
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VLD2.%d {%s[%d], %s[%d]}, [%s%s], %s", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF4A00E0D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		sprintf(ret, "VLD3.%d {%s[], %s[], %s[]}, [%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], vecname[0x22 + param1_1+param1_1 + d], regname[rn]);
	} else if ((opcode & 0xFFB00F0F) == 0xF4A00E0F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		sprintf(ret, "VLD3.%d {%s[], %s[], %s[]}, [%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], vecname[0x22 + param1_1+param1_1 + d], regname[rn]);
	} else if ((opcode & 0xFFB00F00) == 0xF4A00E00) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		sprintf(ret, "VLD3.%d {%s[], %s[], %s[]}, [%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], vecname[0x22 + param1_1+param1_1 + d], regname[rn], regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0020D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = param & (1 << size);
		uint8_t spacing;
		if (temp == 0) {
			spacing = 0;
		} else {
			spacing = 1;
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VLD3.%d {%s[%d], %s[%d], %s[%d]}, [%s]!", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, regname[rn]);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0020F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = param & (1 << size);
		uint8_t spacing;
		if (temp == 0) {
			spacing = 0;
		} else {
			spacing = 1;
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VLD3.%d {%s[%d], %s[%d], %s[%d]}, [%s]", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, regname[rn]);
	} else if ((opcode & 0xFFB00300) == 0xF4A00200) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp = param & (1 << size);
		uint8_t spacing;
		if (temp == 0) {
			spacing = 0;
		} else {
			spacing = 1;
		}
		uint8_t x = param >> (size + 1);
		
		sprintf(ret, "VLD3.%d {%s[%d], %s[%d], %s[%d]}, [%s], %s", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, regname[rn], regname[rm]);
	} else if ((opcode & 0xFFB00F0F) == 0xF4A00F0D) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		char align[5];
		if (param2_1 == 1) {
			sprintf(align, ":%d", 32 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD4.%d {%s[], %s[], %s[], %s[]}, [%s%s]!", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], vecname[0x22 + param1_1+param1_1 + d], vecname[0x23 + param1_1+param1_1+param1_1 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F0F) == 0xF4A00F0F) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		char align[5];
		if (param2_1 == 1) {
			sprintf(align, ":%d", 32 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD4.%d {%s[], %s[], %s[], %s[]}, [%s%s]", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], vecname[0x22 + param1_1+param1_1 + d], vecname[0x23 + param1_1+param1_1+param1_1 + d], regname[rn], align);
	} else if ((opcode & 0xFFB00F00) == 0xF4A00F00) {
		int size = (opcode >> 6) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param1_1 = (opcode >> 5) & 0x1;
		int param2_1 = (opcode >> 4) & 0x1;
		
		char align[5];
		if (param2_1 == 1) {
			sprintf(align, ":%d", 32 << size);
		} else {
			align[0] = '\0';
		}
		
		sprintf(ret, "VLD4.%d {%s[], %s[], %s[], %s[]}, [%s%s], %s", 8 << size, vecname[0x20 + d], vecname[0x21 + param1_1 + d], vecname[0x22 + param1_1+param1_1 + d], vecname[0x23 + param1_1+param1_1+param1_1 + d], regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0030D) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[6];
		if (temp2 == 0b0) {
			align[0] = '\0';
		} else if (temp2 == 0b1) {
			sprintf(align, ":%d", (size ? 64 : 32));
		} else if (temp2 == 0b10) {
			sprintf(align, ":128");
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VLD4.%d {%s[%d], %s[%d], %s[%d], %s[%d]}, [%s%s]!", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, vecname[0x23 + d + 3*spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB0030F) == 0xF4A0030F) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[6];
		if (temp2 == 0b0) {
			align[0] = '\0';
		} else if (temp2 == 0b1) {
			sprintf(align, ":%d", (size ? 64 : 32));
		} else if (temp2 == 0b10) {
			sprintf(align, ":128");
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VLD4.%d {%s[%d], %s[%d], %s[%d], %s[%d]}, [%s%s]", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, vecname[0x23 + d + 3*spacing], x, regname[rn], align);
	} else if ((opcode & 0xFFB00300) == 0xF4A00300) {
		int size = (opcode >> 10) & 0x3;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int param = (opcode >> 4) & 0xF;
		
		uint8_t temp;
		if (size == 0b00) {
			temp = 1;
		} else if (size == 0b01) {
			temp = 1;
		} else {
			temp = 3;
		}
		uint8_t temp2 = param & temp;
		char align[6];
		if (temp2 == 0b0) {
			align[0] = '\0';
		} else if (temp2 == 0b1) {
			sprintf(align, ":%d", (size ? 64 : 32));
		} else if (temp2 == 0b10) {
			sprintf(align, ":128");
		} else {
			sprintf(align, "???");
		}
		uint8_t x = param >> (size + 1);
		int spacing = size ? ((param >> size) & 1) : 0;
		
		sprintf(ret, "VLD4.%d {%s[%d], %s[%d], %s[%d], %s[%d]}, [%s%s], %s", 8 << size, vecname[0x20 + d], x, vecname[0x21 + d + spacing], x, vecname[0x22 + d + 2*spacing], x, vecname[0x23 + d + 3*spacing], x, regname[rn], align, regname[rm]);
	} else if ((opcode & 0xFF100000) == 0xF4000000) {
		strcpy(ret, "???");
	} else if ((opcode & 0xFF700000) == 0xF4100000) {
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 23) & 0x1;
		int param2_8 = (opcode >> 8) & 0xFF;
		int param3_4 = (opcode >> 4) & 0xF;
		int param4_4 = (opcode >> 0) & 0xF;
		
		sprintf(ret, "'NOP'");
	} else if ((opcode & 0xFF700000) == 0xF4500000) {
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "PLI [%s, #%s%d]", regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0xFF300000) == 0xF5100000) {
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		int param = (opcode >> 22) & 0x1;
		
		sprintf(ret, "PLD%s [%s, #%s%d]", param ? "W" : "", regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0xFF3F0000) == 0xF51F0000) {
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "PLD [PC, #%s0x%x]", (u ? "" : "-"), imm12);
	} else if ((opcode & 0xFFF000F0) == 0xF5700010) {
		
		sprintf(ret, "CLREX");
	} else if ((opcode & 0xFFF000F0) == 0xF5700040) {
		int param = (opcode >> 0) & 0xF;
		
		const char* option;
		if (param == 0b1111) {
			option = "SY";
		} else if (param == 0b1110) {
			option = "ST";
		} else if (param == 0b1011) {
			option = "ISH";
		} else if (param == 0b1010) {
			option = "ISHST";
		} else if (param == 0b0111) {
			option = "NSH";
		} else if (param == 0b0110) {
			option = "NSHST";
		} else if (param == 0b0011) {
			option = "OSH";
		} else if (param == 0b0010) {
			option = "OSHST";
		} else {
			option = "!!!";
		}
		
		sprintf(ret, "DSB %s", option);
	} else if ((opcode & 0xFFF000F0) == 0xF5700050) {
		int param = (opcode >> 0) & 0xF;
		
		const char* option;
		if (param == 0b1111) {
			option = "SY";
		} else if (param == 0b1110) {
			option = "ST";
		} else if (param == 0b1011) {
			option = "ISH";
		} else if (param == 0b1010) {
			option = "ISHST";
		} else if (param == 0b0111) {
			option = "NSH";
		} else if (param == 0b0110) {
			option = "NSHST";
		} else if (param == 0b0011) {
			option = "OSH";
		} else if (param == 0b0010) {
			option = "OSHST";
		} else {
			option = "!!!";
		}
		
		sprintf(ret, "DMB %s", option);
	} else if ((opcode & 0xFFF000F0) == 0xF5700060) {
		int param = (opcode >> 0) & 0xF;
		
		const char* option;
		if (param == 0b1111) {
			option = "SY";
		} else {
			option = "!!!";
		}
		
		sprintf(ret, "ISB %s", option);
	} else if ((opcode & 0xFF700010) == 0xF6100000) {
		int rn = (opcode >> 16) & 0xF;
		int param1_1 = (opcode >> 23) & 0x1;
		int param2_8 = (opcode >> 8) & 0xFF;
		int param3_3 = (opcode >> 5) & 0x7;
		int param4_4 = (opcode >> 0) & 0xF;
		
		sprintf(ret, "'NOP'");
	} else if ((opcode & 0xFF700010) == 0xF6500000) {
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "PLI [%s, %s%s%s]", regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0xFF300010) == 0xF7100000) {
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		int param = (opcode >> 22) & 0x1;
		
		sprintf(ret, "PLD%s [%s, %s%s%s]", param ? "W" : "", regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0xFFF000F0) == 0xF7F000F0) {
		strcpy(ret, "???");
	} else if ((opcode & 0xF0000000) == 0xF0000000) {
		strcpy(ret, "???");
	} else if (((opcode & 0x0FE00010) == 0x00000000) || ((opcode & 0x0FE00090) == 0x00000010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "AND%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FE000F0) == 0x00000090) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "MUL%s%s %s, %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x000000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "STRH%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x000000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRD%s %s, %s, [%s], %s%s", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x000000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "STRD%s %s, %s, [%s], %s%s", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x001000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRH%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x001000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRSB%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x001000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRSH%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if (((opcode & 0x0FE00010) == 0x00200000) || ((opcode & 0x0FE00090) == 0x00200010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "EOR%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FE000F0) == 0x00200090) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "MLA%s%s %s, %s, %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0F7000F0) == 0x002000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "STRHT%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x003000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRHT%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x003000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRSBT%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x003000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		
		sprintf(ret, "LDRSHT%s %s, [%s], %s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm]);
	} else if (((opcode & 0x0FE00010) == 0x00400000) || ((opcode & 0x0FE00090) == 0x00400010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "SUB%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x00400090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rdlo = (opcode >> 12) & 0xF;
		int rdhi = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "UMAAL%s %s, %s, %s, %s", cond, regname[rdlo], regname[rdhi], regname[rn], regname[rm]);
	} else if ((opcode & 0x0F7000F0) == 0x004000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "STRH%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x004000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRD%s %s, %s, [%s], #%s%d", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x004000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "STRD%s %s, %s, [%s], #%s%d", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x005000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRH%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x005000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRSB%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x005000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRSH%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if (((opcode & 0x0FE00010) == 0x00600000) || ((opcode & 0x0FE00090) == 0x00600010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "RSB%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x00600090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "MLS%s %s, %s, %s, %s", cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0F7000F0) == 0x006000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "STRHT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x007000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRHT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x007000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRSBT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0F7000F0) == 0x007000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRSHT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8);
	} else if (((opcode & 0x0FE00010) == 0x00800000) || ((opcode & 0x0FE00090) == 0x00800010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "ADD%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FE000F0) == 0x00800090) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rdlo = (opcode >> 12) & 0xF;
		int rdhi = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "UMULL%s%s %s, %s, %s, %s", (s ? "S" : ""), cond, regname[rdlo], regname[rdhi], regname[rn], regname[rm]);
	} else if (((opcode & 0x0FE00010) == 0x00A00000) || ((opcode & 0x0FE00090) == 0x00A00010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "ADC%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FE000F0) == 0x00A00090) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rdlo = (opcode >> 12) & 0xF;
		int rdhi = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "UMLAL%s%s %s, %s, %s, %s", (s ? "S" : ""), cond, regname[rdlo], regname[rdhi], regname[rn], regname[rm]);
	} else if (((opcode & 0x0FE00010) == 0x00C00000) || ((opcode & 0x0FE00090) == 0x00C00010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "SBC%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FE000F0) == 0x00C00090) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rdlo = (opcode >> 12) & 0xF;
		int rdhi = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "SMULL%s%s %s, %s, %s, %s", (s ? "S" : ""), cond, regname[rdlo], regname[rdhi], regname[rn], regname[rm]);
	} else if (((opcode & 0x0FE00010) == 0x00E00000) || ((opcode & 0x0FE00090) == 0x00E00010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "RSC%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FE000F0) == 0x00E00090) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rdlo = (opcode >> 12) & 0xF;
		int rdhi = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "SMLAL%s%s %s, %s, %s, %s", (s ? "S" : ""), cond, regname[rdlo], regname[rdhi], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x01000080) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "SMLABB%s %s, %s, %s, %s", cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0FF000F0) == 0x010000A0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "SMLATB%s %s, %s, %s, %s", cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0FF000F0) == 0x010000C0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "SMLABT%s %s, %s, %s, %s", cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0FF000F0) == 0x010000E0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "SMLATT%s %s, %s, %s, %s", cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0FF000F0) == 0x01000090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "SWP%s %s, %s, [%s]", cond, regname[rt], regname[rm], regname[rn]);
	} else if ((opcode & 0x0F5000F0) == 0x010000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		
		sprintf(ret, "STRH%s %s, [%s, %s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x010000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		
		sprintf(ret, "LDRD%s %s, %s, [%s, %s%s]%s", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), regname[rm], (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x010000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		
		sprintf(ret, "STRD%s %s, %s, [%s, %s%s]%s", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), regname[rm], (w ? "!" : ""));
	} else if (((opcode & 0x0FF00010) == 0x01100000) || ((opcode & 0x0FF00090) == 0x01100010)) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "TST%s %s, %s%s", cond, regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F5000F0) == 0x011000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		
		sprintf(ret, "LDRH%s %s, [%s, %s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x011000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		
		sprintf(ret, "LDRSB%s %s, [%s, %s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x011000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		
		sprintf(ret, "LDRSH%s %s, [%s, %s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], (w ? "!" : ""));
	} else if ((opcode & 0x0FF002F0) == 0x01000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		
		sprintf(ret, "MRS%s %s, APSR", cond, regname[rd]);
	} else if ((opcode & 0x0FF302F0) == 0x01200000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 0) & 0xF;
		int param = (opcode >> 18) & 0x3;
		
		const char* spec_reg;
		if (param == 0b01) {
			spec_reg = "APSR_g";
		} else if (param == 0b10) {
			spec_reg = "APSR_nzcvq";
		} else {
			spec_reg = "APSR_nzcvqg";
		}
		
		sprintf(ret, "MSR%s %s, %s", cond, spec_reg, regname[rn]);
	} else if ((opcode & 0x0FF000F0) == 0x01200010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "BX%s %s", cond, regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x01200020) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "BXJ%s %s", cond, regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x01200030) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "BLX%s %s", cond, regname[rm]);
	} else if ((opcode & 0xFFF000F0) == 0xE1200070) {
		uint16_t imm16 = (((opcode >> 8) & 0xFFF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "BKPT #0x%x", imm16);
	} else if (((opcode & 0x0FF00010) == 0x01300000) || ((opcode & 0x0FF00090) == 0x01300010)) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "TEQ%s %s, %s%s", cond, regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x01400090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "SWPB%s %s, %s, [%s]", cond, regname[rt], regname[rm], regname[rn]);
	} else if ((opcode & 0x0FF000F0) == 0x01600010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "CLZ%s %s, %s", cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0F5000F0) == 0x014000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "STRH%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8, (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x014000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRD%s %s, %s, [%s, #%s%d]%s", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), imm8, (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x014000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "STRD%s %s, %s, [%s, #%s%d]%s", cond, regname[rt], regname[rt + 1], regname[rn], (u ? "" : "-"), imm8, (w ? "!" : ""));
	} else if (((opcode & 0x0FF00010) == 0x01500000) || ((opcode & 0x0FF00090) == 0x01500010)) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "CMP%s %s, %s%s", cond, regname[rn], regname[rm], print_shift(shift, 1));
	} else if (((opcode & 0x0FF00010) == 0x01700000) || ((opcode & 0x0FF00090) == 0x01700010)) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "CMN%s %s, %s%s", cond, regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F5000F0) == 0x015000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRH%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8, (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x015000D0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRSB%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8, (w ? "!" : ""));
	} else if ((opcode & 0x0F5000F0) == 0x015000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = (((opcode >> 8) & 0xF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "LDRSH%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm8, (w ? "!" : ""));
	} else if (((opcode & 0x0FE00010) == 0x01800000) || ((opcode & 0x0FE00090) == 0x01800010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "ORR%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x01800090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rt = (opcode >> 0) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "STREX%s %s, %s, [%s]", cond, regname[rd], regname[rt], regname[rn]);
	} else if ((opcode & 0x0FF000F0) == 0x01900090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "LDREX%s %s, [%s]", cond, regname[rt], regname[rn]);
	} else if ((opcode & 0x0FE00FF0) == 0x01A00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "MOV%s%s %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0FE00070) == 0x01A00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t imm5 = ((opcode >> 7) & 0x1F);
		
		sprintf(ret, "LSL%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rm], imm5);
	} else if ((opcode & 0x0FE000F0) == 0x01A00010) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "LSL%s%s %s, %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FE00070) == 0x01A00020) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t imm5 = ((opcode >> 7) & 0x1F);
		
		sprintf(ret, "LSR%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rm], imm5);
	} else if ((opcode & 0x0FE000F0) == 0x01A00030) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "LSR%s%s %s, %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FE00070) == 0x01A00040) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t imm5 = ((opcode >> 7) & 0x1F);
		
		sprintf(ret, "ASR%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rm], imm5);
	} else if ((opcode & 0x0FE000F0) == 0x01A00050) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "ASR%s%s %s, %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FE00FF0) == 0x01A00060) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "RRX%s%s %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0FE00070) == 0x01A00060) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t imm5 = ((opcode >> 7) & 0x1F);
		
		sprintf(ret, "ROR%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rm], imm5);
	} else if ((opcode & 0x0FE000F0) == 0x01A00070) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "ROR%s%s %s, %s, %s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x01A00090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rt = (opcode >> 0) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "STREXD%s %s, %s, %s, [%s]", cond, regname[rd], regname[rt], regname[rt + 1], regname[rn]);
	} else if ((opcode & 0x0FF000F0) == 0x01B00090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "LDREXD%s %s, %s, [%s]", cond, regname[rt], regname[rt + 1], regname[rn]);
	} else if (((opcode & 0x0FE00010) == 0x01C00000) || ((opcode & 0x0FE00090) == 0x01C00010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "BIC%s%s %s, %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x01C00090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rt = (opcode >> 0) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "STREXB%s %s, %s, [%s]", cond, regname[rd], regname[rt], regname[rn]);
	} else if ((opcode & 0x0FF000F0) == 0x01D00090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "LDREXB%s %s, [%s]", cond, regname[rt], regname[rn]);
	} else if (((opcode & 0x0FE00010) == 0x01E00000) || ((opcode & 0x0FE00090) == 0x01E00010)) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFF);
		
		sprintf(ret, "MVN%s%s %s, %s%s", (s ? "S" : ""), cond, regname[rd], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x01E00090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rt = (opcode >> 0) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "STREXH%s %s, %s, [%s]", cond, regname[rd], regname[rt], regname[rn]);
	} else if ((opcode & 0x0FF000F0) == 0x01F00090) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		
		sprintf(ret, "LDREXH%s %s, [%s]", cond, regname[rt], regname[rn]);
	} else if ((opcode & 0x0FE00000) == 0x02000000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "AND%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02200000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "EOR%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FFF0000) == 0x024F0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "ADR%s %s, #-0x%x", cond, regname[rd], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02400000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "SUB%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02600000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "RSB%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FFF0000) == 0x028F0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "ADR%s %s, #0x%x", cond, regname[rd], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02800000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "ADD%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02A00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "ADC%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02C00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "SBC%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x02E00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "RSC%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FF00000) == 0x03000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		uint16_t imm16 = (((opcode >> 16) & 0xF) << 12) | ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "MOVW%s %s, #0x%x", cond, regname[rd], imm16);
	} else if ((opcode & 0x0FF00000) == 0x03100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "TST%s %s, #0x%x", cond, regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FFF00FF) == 0x03200000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		
		sprintf(ret, "NOP%s", cond);
	} else if ((opcode & 0x0FFF00FF) == 0x03200001) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		
		sprintf(ret, "YIELD%s", cond);
	} else if ((opcode & 0x0FFF00FF) == 0x03200002) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		
		sprintf(ret, "WFE%s", cond);
	} else if ((opcode & 0x0FFF00FF) == 0x03200003) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		
		sprintf(ret, "WFI%s", cond);
	} else if ((opcode & 0x0FFF00FF) == 0x03200004) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		
		sprintf(ret, "SEV%s", cond);
	} else if ((opcode & 0xFFFF00FF) == 0xE3200014) {
		
		sprintf(ret, "CSDB");
	} else if ((opcode & 0x0FFF00F0) == 0x032000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		uint8_t imm4 = ((opcode >> 0) & 0xF);
		
		sprintf(ret, "DBG%s #0x%x", cond, imm4);
	} else if ((opcode & 0x0FFF0000) == 0x03200000) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FF30000) == 0x03200000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		int param = (opcode >> 18) & 0x3;
		
		const char* spec_reg;
		if (param == 0b01) {
			spec_reg = "APSR_g";
		} else if (param == 0b10) {
			spec_reg = "APSR_nzcvq";
		} else {
			spec_reg = "APSR_nzcvqg";
		}
		
		sprintf(ret, "MSR%s %s, #0x%x", cond, spec_reg, imm12);
	} else if ((opcode & 0x0FF30000) == 0x03210000) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FF20000) == 0x03220000) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FF00000) == 0x03600000) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FF00000) == 0x03300000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "TEQ%s %s, #0x%x", cond, regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FF00000) == 0x03400000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		uint16_t imm16 = (((opcode >> 16) & 0xF) << 12) | ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "MOVT%s %s, #0x%x", cond, regname[rd], imm16);
	} else if ((opcode & 0x0FF00000) == 0x03500000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "CMP%s %s, #0x%x", cond, regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FF00000) == 0x03700000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "CMN%s %s, #0x%x", cond, regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x03800000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "ORR%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x03A00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "MOV%s%s %s, #0x%x", (s ? "S" : ""), cond, regname[rd], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x03C00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "BIC%s%s %s, %s, #0x%x", (s ? "S" : ""), cond, regname[rd], regname[rn], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FE00000) == 0x03E00000) {
		int s = (opcode >> 20) & 1;
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "MVN%s%s %s, #0x%x", (s ? "S" : ""), cond, regname[rd], print_modified_imm_ARM(imm12));
	} else if ((opcode & 0x0FFF0FFF) == 0x049D0004) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "POP%s {%s}", cond, regname[rt]);
	} else if ((opcode & 0x0F700000) == 0x04000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "STR%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "LDR%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04200000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "STRT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04300000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "LDRT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04400000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "STRB%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04500000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "LDRB%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04600000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "STRBT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0F700000) == 0x04700000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "LDRBT%s %s, [%s], #%s%d", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12);
	} else if ((opcode & 0x0FFF0FFF) == 0x052D0004) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "PUSH%s {%s}", cond, regname[rt]);
	} else if ((opcode & 0x0F500000) == 0x05000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "STR%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12, (w ? "!" : ""));
	} else if ((opcode & 0x0F500000) == 0x05100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "LDR%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12, (w ? "!" : ""));
	} else if ((opcode & 0x0F500000) == 0x05400000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "STRB%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12, (w ? "!" : ""));
	} else if ((opcode & 0x0F500000) == 0x05500000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint16_t imm12 = ((opcode >> 0) & 0xFFF);
		
		sprintf(ret, "LDRB%s %s, [%s, #%s%d]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), imm12, (w ? "!" : ""));
	} else if ((opcode & 0x0FF000F0) == 0x06100050) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "SSAX%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x06100070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "SSUB16%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x061000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "SSUB8%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x06500050) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "USAX%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x06500070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "USUB16%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x065000F0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "USUB8%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF00070) == 0x06800010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "PKHBT%s %s, %s, %s%s", cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF00070) == 0x06800050) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "PKHTB%s %s, %s, %s%s", cond, regname[rd], regname[rn], regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FFF00F0) == 0x068F0070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "SXTB16%s %s, %s%s}", cond, regname[rd], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06800070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "SXTAB16%s %s, %s, %s%s}", cond, regname[rd], regname[rn], regname[rm], tmprot);
	} else if ((opcode & 0x0FE00030) == 0x06A00010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		uint8_t imm = ((opcode >> 16) & 0x1F) + 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "SSAT%s %s, #%d, %s%s", cond, regname[rd], imm, regname[rn], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x06A00030) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		uint8_t imm4 = ((opcode >> 16) & 0xF);
		
		sprintf(ret, "SSAT16%s %s, #0x%x, %s", cond, regname[rd], imm4, regname[rn]);
	} else if ((opcode & 0x0FFF00F0) == 0x06AF0070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "SXTB%s %s, %s%s}", cond, regname[rd], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06A00070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "SXTAB%s %s, %s, %s%s}", cond, regname[rd], regname[rn], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06B00030) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "REV%s %s, %s", cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x06B000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "REV16%s %s, %s", cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0FFF00F0) == 0x06BF0070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "SXTH%s %s, %s%s}", cond, regname[rd], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06B00070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "SXTAH%s %s, %s, %s%s}", cond, regname[rd], regname[rn], regname[rm], tmprot);
	} else if ((opcode & 0x0FFF00F0) == 0x06CF0070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "UXTB16%s %s, %s%s}", cond, regname[rd], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06C00070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "UXTAB16%s %s, %s, %s%s}", cond, regname[rd], regname[rn], regname[rm], tmprot);
	} else if ((opcode & 0x0FE00030) == 0x06E00010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		uint8_t imm = ((opcode >> 16) & 0x1F) + 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "USAT%s %s, #%d, %s%s", cond, regname[rd], imm, regname[rn], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x06E00030) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		uint8_t imm4 = ((opcode >> 16) & 0xF);
		
		sprintf(ret, "USAT16%s %s, #0x%x, %s", cond, regname[rd], imm4, regname[rn]);
	} else if ((opcode & 0x0FFF00F0) == 0x06EF0070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "UXTB%s %s, %s%s}", cond, regname[rd], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06E00070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "UXTAB%s %s, %s, %s%s}", cond, regname[rd], regname[rn], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06F00030) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "RBIT%s %s, %s", cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0FFF00F0) == 0x06FF0070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "UXTH%s %s, %s%s}", cond, regname[rd], regname[rm], tmprot);
	} else if ((opcode & 0x0FF000F0) == 0x06F000B0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		
		sprintf(ret, "REVSH%s %s, %s", cond, regname[rd], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x06F00070) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int rot = (opcode >> 10) & 3;
		char tmprot[8] = {0};
		if (rot) {
			sprintf(tmprot, " ror %d", rot * 8);
		}
		
		sprintf(ret, "UXTAH%s %s, %s, %s%s}", cond, regname[rd], regname[rn], regname[rm], tmprot);
	} else if ((opcode & 0x0F700010) == 0x06000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "STR%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "LDR%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06200000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "STRT%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06300000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "LDRT%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06400000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "STRB%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06500000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "LDRB%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06600000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "STRBT%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0F700010) == 0x06700000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "LDRBT%s %s, [%s], %s%s%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1));
	} else if ((opcode & 0x0FF000F0) == 0x07100010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "SDIV%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x07300010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "UDIV%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0F500010) == 0x07000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "STR%s %s, [%s, %s%s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1), (w ? "!" : ""));
	} else if ((opcode & 0x0F500010) == 0x07100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "LDR%s %s, [%s, %s%s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1), (w ? "!" : ""));
	} else if ((opcode & 0x0F500010) == 0x07400000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "STRB%s %s, [%s, %s%s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1), (w ? "!" : ""));
	} else if ((opcode & 0x0F500010) == 0x07500000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int rm = (opcode >> 0) & 0xF;
		int u = (opcode >> 23) & 1;
		int w = (opcode >> 21) & 1;
		uint8_t shift = ((opcode >> 4) & 0xFE);
		
		sprintf(ret, "LDRB%s %s, [%s, %s%s%s]%s", cond, regname[rt], regname[rn], (u ? "" : "-"), regname[rm], print_shift(shift, 1), (w ? "!" : ""));
	} else if ((opcode & 0x0FF0F0F0) == 0x0780F010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		
		sprintf(ret, "USAD8%s %s, %s, %s", cond, regname[rd], regname[rn], regname[rm]);
	} else if ((opcode & 0x0FF000F0) == 0x07800010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 16) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int rm = (opcode >> 8) & 0xF;
		int ra = (opcode >> 12) & 0xF;
		
		sprintf(ret, "USADA8%s %s, %s, %s, %s", cond, regname[rd], regname[rn], regname[rm], regname[ra]);
	} else if ((opcode & 0x0FE0007F) == 0x07C0001F) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int lsb = (opcode >> 7) & 0x1F;
		int msb = (opcode >> 16) & 0x1F;
		
		sprintf(ret, "BFC%s %s, #%d, #%d", cond, regname[rd], lsb, msb - lsb + 1);
	} else if ((opcode & 0x0FE00070) == 0x07C00010) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int lsb = (opcode >> 7) & 0x1F;
		int msb = (opcode >> 16) & 0x1F;
		
		sprintf(ret, "BFI%s %s, %s, #%d, #%d", cond, regname[rd], regname[rn], lsb, msb - lsb + 1);
	} else if ((opcode & 0x0FE00070) == 0x07E00050) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rd = (opcode >> 12) & 0xF;
		int rn = (opcode >> 0) & 0xF;
		int lsb = (opcode >> 7) & 0x1F;
		int widthm1 = (opcode >> 16) & 0x1F;
		
		sprintf(ret, "UBFX%s %s, %s, #%d, #%d", cond, regname[rd], regname[rn], lsb, widthm1 + 1);
	} else if ((opcode & 0xFFF000F0) == 0xE7F000F0) {
		uint16_t imm16 = (((opcode >> 8) & 0xFFF) << 4) | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "UDF #0x%x", imm16);
	} else if ((opcode & 0x0FDF0000) == 0x080D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMED%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x08000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMDA%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FDF0000) == 0x081D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMED%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x08100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMDA%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FDF0000) == 0x088D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMEA%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x08800000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STM%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FFF0000) == 0x089D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMEA%s %s, %s", cond, regname[rn], print_register_list(reglist, 16));
	} else if ((opcode & 0x0FFF0000) == 0x08BD0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int reglist = (opcode >> 0) & 0xFFFF;
		
		const char* op;
		if ((reglist != 0) && ((reglist & (reglist - 1)) == 0)) {
			op = "POP";
		} else {
			op = "LDMEA";
		}
		
		sprintf(ret, "%s%s %s", op, cond, print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x08900000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDM%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FFF0000) == 0x090D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMFD%s %s, %s", cond, regname[rn], print_register_list(reglist, 16));
	} else if ((opcode & 0x0FFF0000) == 0x092D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int reglist = (opcode >> 0) & 0xFFFF;
		
		const char* op;
		if ((reglist != 0) && ((reglist & (reglist - 1)) == 0)) {
			op = "PUSH";
		} else {
			op = "STMFD";
		}
		
		sprintf(ret, "%s%s %s", op, cond, print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x09000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMDB%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FDF0000) == 0x091D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMFD%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x09100000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMDB%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FDF0000) == 0x098D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMFA%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x09800000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "STMIB%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FDF0000) == 0x099D0000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMFA%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0FD00000) == 0x09900000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		int reglist = (opcode >> 0) & 0xFFFF;
		
		sprintf(ret, "LDMIB%s %s%s, %s", cond, regname[rn], (w ? "!" : ""), print_register_list(reglist, 16));
	} else if ((opcode & 0x0F000000) == 0x0A000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		uint32_t imm24 = ((opcode >> 0) & 0xFFFFFF);
		
		sprintf(ret, "B%s %+d", cond, (imm24 & 0x800000 ? imm24 | 0xFF000000 : imm24) + 2);
	} else if ((opcode & 0x0F000000) == 0x0B000000) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		uint32_t imm24 = ((opcode >> 0) & 0xFFFFFF);
		
		sprintf(ret, "BL%s %+d", cond, (imm24 & 0x800000 ? imm24 | 0xFF000000 : imm24) + 2);
	} else if ((opcode & 0x0FF00FD0) == 0x0C400A10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOV%s %s, %s, %s, %s", cond, vecname[m], vecname[m + 1], regname[rt], regname[rn]);
	} else if ((opcode & 0x0FF00FD0) == 0x0C500A10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOV%s %s, %s, %s, %s", cond, regname[rt], regname[rn], vecname[m], vecname[m + 1]);
	} else if ((opcode & 0x0FF00FD0) == 0x0C400B10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOV%s %s, %s, %s", cond, vecname[0x20 + m], regname[rt], regname[rn]);
	} else if ((opcode & 0x0FF00FD0) == 0x0C500B10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int rn = (opcode >> 16) & 0xF;
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOV%s %s, %s, %s", cond, regname[rt], regname[rn], vecname[0x20 + m]);
	} else if ((opcode & 0x0F800E00) == 0x0C000A00) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0F800E00) == 0x0C000A00) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FA00E00) == 0x0DA00A00) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FA00E00) == 0x0DA00A00) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FBF0F01) == 0x0D2D0B01) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		--imm8;
		
		sprintf(ret, "FSTMX%s %s", cond, print_register_list_fpu(d, imm8, 1));
	} else if ((opcode & 0x0FBF0E00) == 0x0D2D0A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		sprintf(ret, "VPUSH%s %s", cond, print_register_list_fpu(d, imm8, size));
	} else if ((opcode & 0x0F300E00) == 0x0D000A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int u = (opcode >> 23) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		imm8*=4;
		
		sprintf(ret, "VSTR%s %s, [%s, #%s%d]", cond, vecname[(size << 5) + d], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0E100F01) == 0x0C000B01) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		int param = (opcode >> 23) & 0x3;
		
		--imm8;
		
		sprintf(ret, "FSTM%sX%s %s%s, %s", (param == 0b01 ? "IA" : "DB"), cond, regname[rn], (w ? "!" : ""), print_register_list_fpu(d, imm8, 1));
	} else if ((opcode & 0x0E100E00) == 0x0C000A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		int param = (opcode >> 23) & 0x3;
		
		sprintf(ret, "VSTM%s%s %s%s, %s", (param == 0b01 ? "IA" : "DB"), cond, regname[rn], (w ? "!" : ""), print_register_list_fpu(d, imm8, size));
	} else if ((opcode & 0x0FBF0F01) == 0x0CBD0B01) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		--imm8;
		
		sprintf(ret, "FLDMX%s %s", cond, print_register_list_fpu(d, imm8, 1));
	} else if ((opcode & 0x0FBF0E00) == 0x0CBD0A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		sprintf(ret, "VPOP%s %s", cond, print_register_list_fpu(d, imm8, size));
	} else if ((opcode & 0x0FBF0EFF) == 0x0D1F0A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		
		sprintf(ret, "VLDR%s %s, [PC, #-0]", cond, vecname[(size << 5) + d]);
	} else if ((opcode & 0x0F3F0E00) == 0x0D1F0A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int u = (opcode >> 23) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		sprintf(ret, "VLDR%s %s, %s%d", cond, vecname[(size << 5) + d], (u ? "" : "-"), imm8 + 2);
	} else if ((opcode & 0x0F300E00) == 0x0D100A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int u = (opcode >> 23) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		
		imm8*=4;
		
		sprintf(ret, "VLDR%s %s, [%s, #%s%d]", cond, vecname[(size << 5) + d], regname[rn], (u ? "" : "-"), imm8);
	} else if ((opcode & 0x0E100F01) == 0x0C100B01) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		int param = (opcode >> 23) & 0x3;
		
		--imm8;
		
		sprintf(ret, "FLDM%sX%s %s%s, %s", (param == 0b01 ? "IA" : "DB"), cond, regname[rn], (w ? "!" : ""), print_register_list_fpu(d, imm8, 1));
	} else if ((opcode & 0x0E100E00) == 0x0C100A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int rn = (opcode >> 16) & 0xF;
		int w = (opcode >> 21) & 1;
		uint8_t imm8 = ((opcode >> 0) & 0xFF);
		int param = (opcode >> 23) & 0x3;
		
		sprintf(ret, "VLDM%s%s %s%s, %s", (param == 0b01 ? "IA" : "DB"), cond, regname[rn], (w ? "!" : ""), print_register_list_fpu(d, imm8, size));
	} else if ((opcode & 0x0E000000) == 0x0C000000) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FD00F70) == 0x0E000B50) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FF00F10) == 0x0E000A10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		
		sprintf(ret, "VMOV%s %s, %s", cond, vecname[n], regname[rt]);
	} else if ((opcode & 0x0FFF0F10) == 0x0EE10A10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "VMSR%s FPSCR, %s", cond, regname[rt]);
	} else if ((opcode & 0x0F900F10) == 0x0E000B10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int rt = (opcode >> 12) & 0xF;
		int param1_2 = (opcode >> 21) & 0x3;
		int param2_2 = (opcode >> 5) & 0x3;
		
		uint8_t opc = (param1_2 << 2) + param2_2;
		uint8_t shift;
		if ((opc & 0b1000) == 0b1000) {
			shift = 0;
		} else if ((opc & 0b1001) == 0b0001) {
			shift = 1;
		} else if ((opc & 0b1011) == 0b0000) {
			shift = 2;
		} else {
			shift = 0xFF;
		}
		uint8_t decodedImm = (opc & 0x7) >> shift;
		
		sprintf(ret, "VMOV%s.%d %s[%d], %s", cond, 8 << shift, vecname[0x20 + d], decodedImm, regname[rt]);
	} else if ((opcode & 0x0FD00F70) == 0x0E800B10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int q = (opcode >> 21) & 1;
		int d = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "VDUP%s.32 %s, %s", cond, vecname[(q << 5) + 0x20 + d], regname[rt]);
	} else if ((opcode & 0x0FD00F70) == 0x0E800B30) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int q = (opcode >> 21) & 1;
		int d = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "VDUP%s.16 %s, %s", cond, vecname[(q << 5) + 0x20 + d], regname[rt]);
	} else if ((opcode & 0x0FD00F70) == 0x0EC00B10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int q = (opcode >> 21) & 1;
		int d = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "VDUP%s.8 %s, %s", cond, vecname[(q << 5) + 0x20 + d], regname[rt]);
	} else if ((opcode & 0x0FF00F10) == 0x0E100A10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		
		sprintf(ret, "VMOV%s %s, %s", cond, regname[rt], vecname[n]);
	} else if ((opcode & 0x0FFFFF10) == 0x0EF1FA10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "VMRS%s APSR_nzcv, FPSCR", cond);
	} else if ((opcode & 0x0FFF0F10) == 0x0EF10A10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int rt = (opcode >> 12) & 0xF;
		
		sprintf(ret, "VMRS%s %s, FPSCR", cond, regname[rt]);
	} else if ((opcode & 0x0F100F10) == 0x0E100B10) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int u = (opcode >> 23) & 1;
		int rt = (opcode >> 12) & 0xF;
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int param1_2 = (opcode >> 21) & 0x3;
		int param2_2 = (opcode >> 5) & 0x3;
		
		uint8_t opc = (u << 4) + (param1_2 << 2) + param2_2;
		uint8_t shift, size;
		if ((opc & 0b01000) == 0b01000) {
			shift = 0;
			size = 0;
		} else if ((opc & 0b01001) == 0b00001) {
			shift = 1;
			size = 1;
		} else if ((opc & 0b11011) == 0b00000) {
			shift = 2;
			size = 2;
		} else {
			shift = 0xFF;
			size = 4;
		}
		uint8_t decodedImm = (opc & 0x7) >> shift;
		
		sprintf(ret, "VMOV%s.%s %s, %s[%d]", cond, dts[(u << 2) + size], regname[rt], vecname[0x20 + n], decodedImm);
	} else if ((opcode & 0x0F000E10) == 0x0E000A10) {
		strcpy(ret, "???");
	} else if ((opcode & 0x0FB00E10) == 0x0E000A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 6) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VML%s%s.F%s %s, %s, %s", (op ? "S" : "A"), cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E10) == 0x0E100A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 6) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VNML%s%s.F%s %s, %s, %s", (op ? "S" : "A"), cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E50) == 0x0E200A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMUL%s.F%s %s, %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E50) == 0x0E200A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VNMUL%s.F%s %s, %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E50) == 0x0E300A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VADD%s.F%s %s, %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E50) == 0x0E300A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSUB%s.F%s %s, %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E50) == 0x0E800A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VDIV%s.F%s %s, %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E10) == 0x0E900A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 6) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VFNM%s%s.F%s %s, %s, %s", (op ? "A" : "S"), cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00E10) == 0x0EA00A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 6) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int n = ((opcode >> 7) & 1) << 4 | ((opcode >> 16) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VFM%s%s.F%s %s, %s, %s", (op ? "S" : "A"), cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + n], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FB00F50) == 0x0EB00A00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int param1_4 = (opcode >> 16) & 0xF;
		int param2_4 = (opcode >> 0) & 0xF;
		
		int8_t sign = (param1_4 >> 3) ? -1 : 1;
		uint8_t exp = ((param1_4 & 0b111) ^ 0b100);
		float mantissa = 16 + param2_4;
		float imm = sign * (1 << exp) * mantissa / 128.;
		
		sprintf(ret, "VMOV%s.F32 %s, #%f", cond, vecname[d], imm);
	} else if ((opcode & 0x0FB00F50) == 0x0EB00B00) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int param1_4 = (opcode >> 16) & 0xF;
		int param2_4 = (opcode >> 0) & 0xF;
		
		int8_t sign = (param1_4 >> 3) ? -1 : 1;
		uint8_t exp = ((param1_4 & 0b111) ^ 0b100);
		double mantissa = 16 + param2_4;
		double imm = sign * (1 << exp) * mantissa / 128.;
		
		sprintf(ret, "VMOV%s.F64 %s, #%f", cond, vecname[0x20 + d], imm);
	} else if ((opcode & 0x0FBF0ED0) == 0x0EB00A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VMOV%s.F%s %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FBF0ED0) == 0x0EB00AC0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VABS%s.F%s %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FBF0ED0) == 0x0EB10A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VNEG%s.F%s %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FBF0ED0) == 0x0EB10AC0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VSQRT%s.F%s %s, %s", cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FBF0E50) == 0x0EB20A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		int param = (opcode >> 7) & 0x1;
		
		sprintf(ret, "VCVT%s%s.F32.F16 %s, %s", (param ? "T" : "B"), cond, vecname[d], vecname[m]);
	} else if ((opcode & 0x0FBF0E50) == 0x0EB30A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		int param = (opcode >> 7) & 0x1;
		
		sprintf(ret, "VCVT%s%s.F16.F32 %s, %s", (param ? "T" : "B"), cond, vecname[d], vecname[m]);
	} else if ((opcode & 0x0FBF0E50) == 0x0EB40A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 7) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCMP%s%s.F%s %s, %s", (op ? "E" : ""), cond, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FBF0E50) == 0x0EB50A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 7) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		
		sprintf(ret, "VCMP%s%s.F%s %s, #0.0", (op ? "E" : ""), cond, (size ? "64" : "32"), vecname[(size << 5) + d]);
	} else if ((opcode & 0x0FBF0FD0) == 0x0EB70AC0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT%s.F64.F32 %s, %s", cond, vecname[0x20 + d], vecname[m]);
	} else if ((opcode & 0x0FBF0FD0) == 0x0EB70BC0) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT%s.F32.F64 %s, %s", cond, vecname[d], vecname[0x20 + m]);
	} else if ((opcode & 0x0FBF0E50) == 0x0EB80A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 7) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT%s.F%s.%s32 %s, %s", cond, (size ? "64" : "32"), (op ? "S" : "U"), vecname[(size << 5) + d], vecname[m]);
	} else if ((opcode & 0x0FBE0E50) == 0x0EBA0A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 7) & 1;
		int u = (opcode >> 16) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm5 = (((opcode >> 5) & 0x1) << 4) | ((opcode >> 0) & 0xF);
		
		uint8_t td = (u << 2) + op + 1;
		const char* Td;
		if (td == 0b001) {
			Td = "S16";
		} else if (td == 0b010) {
			Td = "U16";
		} else if (td == 0b101) {
			Td = "S32";
		} else {
			Td = "U32";
		}
		imm5 = (16 << op) - (imm5 >> 4) - ((imm5 & 0xF) << 1);
		
		sprintf(ret, "VCVT%s.F%s.%s %s, %s, #%d", cond, (size ? "64" : "32"), Td, vecname[(size << 5) + d], vecname[(size << 5) + d], imm5);
	} else if ((opcode & 0x0FBD0E50) == 0x0EBD0A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 7) & 1;
		int u = (opcode >> 17) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		int m = ((opcode >> 5) & 1) << 4 | ((opcode >> 0) & 0xF);
		
		sprintf(ret, "VCVT%s%s.%s32.F%s %s, %s", (op ? "" : "R"), cond, (u ? "U" : "S"), (size ? "64" : "32"), vecname[d], vecname[(size << 5) + m]);
	} else if ((opcode & 0x0FBE0E50) == 0x0EBE0A40) {
		const char* cond = conds[(opcode >> 28) & 0xF];
		int op = (opcode >> 7) & 1;
		int u = (opcode >> 16) & 1;
		int size = (opcode >> 8) & 0x1;
		int d = ((opcode >> 22) & 1) << 4 | ((opcode >> 12) & 0xF);
		uint8_t imm5 = (((opcode >> 5) & 0x1) << 4) | ((opcode >> 0) & 0xF);
		
		uint8_t td = (u << 2) + op + 1;
		const char* Td;
		if (td == 0b001) {
			Td = "S16";
		} else if (td == 0b010) {
			Td = "U16";
		} else if (td == 0b101) {
			Td = "S32";
		} else {
			Td = "U32";
		}
		imm5 = (16 << op) - (imm5 >> 4) - ((imm5 & 0xF) << 1);
		
		sprintf(ret, "VCVT%s.%s.F%s %s, %s, #%d", cond, Td, (size ? "64" : "32"), vecname[(size << 5) + d], vecname[(size << 5) + d], imm5);
	} else {
		strcpy(ret, "???");
	}
	
	return ret;
}
