/* Generated automatically by the program 'build/genpreds'
   from the machine description file '/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/arm.md'.  */

#define IN_TARGET_CODE 1
#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "tree.h"
#include "rtl.h"
#include "alias.h"
#include "varasm.h"
#include "stor-layout.h"
#include "calls.h"
#include "memmodel.h"
#include "tm_p.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "emit-rtl.h"
#include "tm-constrs.h"
#include "target.h"


struct target_constraints default_target_constraints;
#if SWITCHABLE_TARGET
struct target_constraints *this_target_constraints = &default_target_constraints;
#endif
static inline bool
aligned_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 25 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/common.md"
{
  /* Require the offset in a non-paradoxical subreg to be naturally aligned.
     For example, if we have a subreg of something that is double the size of
     this operand, the offset must select the first or second half of it.  */
  if (SUBREG_P (op)
      && multiple_p (SUBREG_BYTE (op), GET_MODE_SIZE (GET_MODE (op))))
    op = SUBREG_REG (op);
  if (!REG_P (op))
    return false;

  if (HARD_REGISTER_P (op))
    {
      if (!in_hard_reg_set_p (operand_reg_set, GET_MODE (op), REGNO (op)))
	return false;

      /* Reject hard registers that would need reloading, so that the reload
	 is visible to IRA and to pre-RA optimizers.  */
      if (REGNO (op) % REG_NREGS (op) != 0)
	return false;
    }
  return true;
}

bool
aligned_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
      break;
    default:
      return false;
    }
  return (
(aligned_register_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
const_1_to_4_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 24 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/common.md"
(IN_RANGE (INTVAL (op), 1, 4)));
}

bool
const_2_4_8_16_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 29 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/common.md"
(   INTVAL (op) == 2
                     || INTVAL (op) == 4
                     || INTVAL (op) == 8
                     || INTVAL (op) == 16 ));
}

bool
alu_shift_operator_lsl_1_to_4 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == ASHIFT) && (
#line 37 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/common.md"
(const_1_to_4_operand (XEXP (op, 1), mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
alu_shift_reg_p (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 41 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/common.md"
(register_operand (XEXP (op, 1), mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

static inline bool
s_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 25 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (GET_CODE (op) == SUBREG)
    op = SUBREG_REG (op);
  /* We don't consider registers whose class is NO_REGS
     to be a register operand.  */
  /* XXX might have to check for lo regs only for thumb ??? */
  return (REG_P (op)
	  && (REGNO (op) >= FIRST_PSEUDO_REGISTER
	      || REGNO_REG_CLASS (REGNO (op)) != NO_REGS));
}

bool
s_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
      break;
    default:
      return false;
    }
  return (
(s_register_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
mve_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
#line 38 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_32BIT
		    && mve_vector_mem_operand (GET_MODE (op), XEXP (op, 0),
					       false)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
mve_scatter_memory (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
#line 44 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_HAVE_MVE && REG_P (XEXP (op, 0))
		    && mve_vector_mem_operand (GET_MODE (op), XEXP (op, 0),
					       false)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
mve_imm_16 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 50 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Rd (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_imm_7 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 54 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Ra (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_imm_8 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 58 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Rb (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_imm_15 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 62 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Rc (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_imm_31 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 66 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Re (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_imm_32 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 70 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Rf (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_imm_selective_upto_8 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 74 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Rg (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_vldrd_immediate (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 78 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Ri (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mve_vstrw_immediate (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 82 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Rl (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

static inline bool
guard_addr_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 88 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return (CONSTANT_ADDRESS_P (op)
	  || !targetm.cannot_force_const_mem (mode, op));
}

bool
guard_addr_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((
#line 87 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(true)) && (
(guard_addr_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

static inline bool
guard_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 97 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return guard_addr_operand (XEXP (op, 0), mode);
}

bool
guard_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
(guard_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

static inline bool
vpr_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 103 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return REG_P (op)
	  && (REGNO (op) >= FIRST_PSEUDO_REGISTER
	      || IS_VPR_REGNUM (REGNO (op)));
}

bool
vpr_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == REG) && (
(vpr_register_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

static inline bool
imm_for_neon_inv_logic_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 111 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return ((TARGET_NEON || TARGET_HAVE_MVE)
          && neon_immediate_valid_for_logic (op, mode, 1, NULL, NULL));
}

bool
imm_for_neon_inv_logic_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_VECTOR) && (
(imm_for_neon_inv_logic_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
neon_inv_logic_op2 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (imm_for_neon_inv_logic_operand (op, mode)) || (s_register_operand (op, mode));
}

static inline bool
imm_for_neon_logic_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 122 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return ((TARGET_NEON || TARGET_HAVE_MVE)
          && neon_immediate_valid_for_logic (op, mode, 0, NULL, NULL));
}

bool
imm_for_neon_logic_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_VECTOR) && (
(imm_for_neon_logic_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
neon_logic_op2 (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (imm_for_neon_logic_operand (op, mode)) || (s_register_operand (op, mode));
}

static inline bool
arm_hard_general_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 134 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return REGNO (op) <= LAST_ARM_REGNUM;
}

bool
arm_hard_general_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == REG) && (
(arm_hard_general_register_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
low_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == REG) && (
#line 141 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(REGNO (op) <= LAST_LO_REGNUM))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
low_reg_or_int_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_INT) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode))) || (low_register_operand (op, mode));
}

static inline bool
arm_general_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 151 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (GET_CODE (op) == SUBREG)
    op = SUBREG_REG (op);

  return (REG_P (op)
	  && (REGNO (op) <= LAST_ARM_REGNUM
	      || REGNO (op) >= FIRST_PSEUDO_REGISTER));
}

bool
arm_general_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
      break;
    default:
      return false;
    }
  return (
(arm_general_register_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

static inline bool
arm_low_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 163 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (GET_CODE (op) == SUBREG)
    op = SUBREG_REG (op);

  return (REG_P (op)
	  && (REGNO (op) <= LAST_LO_REGNUM
	      || REGNO (op) >= FIRST_PSEUDO_REGISTER));
}

bool
arm_low_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
      break;
    default:
      return false;
    }
  return (
(arm_low_register_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
arm_general_adddi_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_general_register_operand (op, mode)) || (((GET_CODE (op) == CONST_INT) && (
#line 175 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_dimode_op (INTVAL (op), PLUS)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode)));
}

static inline bool
vfp_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 179 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (GET_CODE (op) == SUBREG)
    op = SUBREG_REG (op);

  /* We don't consider registers whose class is NO_REGS
     to be a register operand.  */
  return (REG_P (op)
	  && (REGNO (op) >= FIRST_PSEUDO_REGISTER
	      || REGNO_REG_CLASS (REGNO (op)) == VFP_D0_D7_REGS
	      || REGNO_REG_CLASS (REGNO (op)) == VFP_LO_REGS
	      || (TARGET_VFPD32
		  && REGNO_REG_CLASS (REGNO (op)) == VFP_HI_REGS)));
}

bool
vfp_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
      break;
    default:
      return false;
    }
  return (
(vfp_register_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

static inline bool
vfp_hard_register_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 195 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return (IS_VFP_REGNUM (REGNO (op)));
}

bool
vfp_hard_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == REG) && (
(vfp_hard_register_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
zero_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      break;
    default:
      return false;
    }
  return (
#line 201 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(op == CONST0_RTX (mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
minus_one_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      break;
    default:
      return false;
    }
  return (
#line 205 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(op == CONSTM1_RTX (mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
reg_or_zero_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (zero_operand (op, mode));
}

bool
subreg_lowpart_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == SUBREG) && (
#line 214 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(subreg_lowpart_p (op)));
}

bool
reg_or_int_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_INT) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode))) || (s_register_operand (op, mode));
}

bool
arm_immediate_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 223 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_arm (INTVAL (op))));
}

bool
arm_immediate_di_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case CONST_INT:
    case CONST_DOUBLE:
      break;
    default:
      return false;
    }
  return (
#line 229 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_const_double_by_immediates (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
arm_neg_immediate_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 233 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_arm (-INTVAL (op))));
}

bool
arm_not_immediate_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 237 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_arm (~INTVAL (op))));
}

bool
const0_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 240 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(op == CONST0_RTX (mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
arm_rhs_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (arm_immediate_operand (op, mode));
}

bool
arm_rhsm_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_rhs_operand (op, mode)) || (memory_operand (op, mode));
}

bool
const_int_I_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 253 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_I (op)));
}

bool
const_int_M_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 257 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_M (op)));
}

bool
const_int_coproc_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && ((
#line 261 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_CDE_CONST_COPROC))) && (
#line 262 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_arch_cde_coproc_bits[UINTVAL (op)] & arm_arch_cde_coproc)));
}

bool
const_int_ccde1_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 266 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_CCDE_CONST_1)));
}

bool
const_int_ccde2_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 270 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_CCDE_CONST_2)));
}

bool
const_int_ccde3_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 274 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_CCDE_CONST_3)));
}

bool
const_int_vcde1_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 278 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_VCDE_CONST_1)));
}

bool
const_int_vcde2_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 282 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_VCDE_CONST_2)));
}

bool
const_int_vcde3_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 286 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_VCDE_CONST_3)));
}

bool
const_int_mve_cde1_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 290 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_MVE_CDE_CONST_1)));
}

bool
const_int_mve_cde2_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 294 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_MVE_CDE_CONST_2)));
}

bool
const_int_mve_cde3_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 298 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 0, ARM_MVE_CDE_CONST_3)));
}

bool
shift_amount_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((
#line 303 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_ARM)) && (s_register_operand (op, mode))) || (const_int_operand (op, mode));
}

bool
const_neon_scalar_shift_amount_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 309 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (UINTVAL (op), 1, GET_MODE_BITSIZE (mode))));
}

bool
ssat16_imm (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 313 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (INTVAL (op), 1, 16)));
}

bool
usat16_imm (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 317 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(IN_RANGE (INTVAL (op), 0, 15)));
}

bool
ldrd_strd_offset_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (const_int_operand (op, mode)) && (
#line 321 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_LDRD && offset_ok_for_ldrd_strd (INTVAL (op))));
}

bool
arm_add_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_rhs_operand (op, mode)) || (arm_neg_immediate_operand (op, mode));
}

bool
arm_adddi_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (((GET_CODE (op) == CONST_INT) && (
#line 330 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_dimode_op (INTVAL (op), PLUS)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode)));
}

bool
arm_anddi_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (((GET_CODE (op) == CONST_INT) && (
#line 335 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_dimode_op (INTVAL (op), AND)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode)));
}

bool
arm_iordi_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (((GET_CODE (op) == CONST_INT) && (
#line 340 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_dimode_op (INTVAL (op), IOR)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode)));
}

bool
arm_xordi_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (((GET_CODE (op) == CONST_INT) && (
#line 345 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(const_ok_for_dimode_op (INTVAL (op), XOR)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode)));
}

bool
arm_addimm_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_immediate_operand (op, mode)) || (arm_neg_immediate_operand (op, mode));
}

bool
arm_not_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_rhs_operand (op, mode)) || (arm_not_immediate_operand (op, mode));
}

bool
arm_adcimm_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_immediate_operand (op, mode)) || (arm_not_immediate_operand (op, mode));
}

bool
arm_di_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (arm_immediate_di_operand (op, mode));
}

bool
offsettable_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
#line 370 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(offsettable_address_p (reload_completed | reload_in_progress,
				mode, XEXP (op, 0))))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
call_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == MEM) && ((
#line 377 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(GET_RTX_CLASS (GET_CODE (XEXP (op, 0)))
			 != RTX_AUTOINC)) && (memory_operand (op, mode)));
}

bool
arm_reload_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case MEM:
    case REG:
    case SUBREG:
      break;
    default:
      return false;
    }
  return (
#line 383 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
((!CONSTANT_P (op)
		     && (true_regnum(op) == -1
			 || (REG_P (op)
			     && REGNO (op) >= FIRST_PSEUDO_REGISTER))))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
vfp_compare_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (((GET_CODE (op) == CONST_DOUBLE) && (
#line 391 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_const_double_rtx (op)))) && (
(mode == VOIDmode || GET_MODE (op) == mode)));
}

bool
index_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || ((immediate_operand (op, mode)) && (
#line 397 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
((!CONST_INT_P (op)
			  || (INTVAL (op) < 4096 && INTVAL (op) > -4096)))));
}

bool
shiftable_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case PLUS:
    case MINUS:
    case IOR:
    case XOR:
    case AND:
      break;
    default:
      return false;
    }
  return 
#line 403 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op));
}

bool
shiftable_operator_strict_it (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case PLUS:
    case AND:
      break;
    default:
      return false;
    }
  return 
#line 407 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op));
}

bool
logical_binary_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case IOR:
    case XOR:
    case AND:
      break;
    default:
      return false;
    }
  return 
#line 412 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op));
}

bool
commutative_binary_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case IOR:
    case XOR:
    case AND:
    case PLUS:
      break;
    default:
      return false;
    }
  return 
#line 417 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op));
}

bool
shift_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((((GET_CODE (op) == MULT) && (
#line 427 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(power_of_two_operand (XEXP (op, 1), mode)))) || ((GET_CODE (op) == ROTATE) && (
#line 429 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(CONST_INT_P (XEXP (op, 1))
				   && (UINTVAL (XEXP (op, 1))) < 32)))) || ((GET_CODE (op) == ASHIFT || GET_CODE (op) == ASHIFTRT || GET_CODE (op) == LSHIFTRT || GET_CODE (op) == ROTATERT) && (
#line 432 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(!CONST_INT_P (XEXP (op, 1))
			      || (UINTVAL (XEXP (op, 1))) < 32)))) && (
#line 434 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op)));
}

bool
shift_nomul_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (((GET_CODE (op) == ROTATE) && (
#line 438 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(CONST_INT_P (XEXP (op, 1))
			      && (UINTVAL (XEXP (op, 1))) < 32))) || ((GET_CODE (op) == ASHIFT || GET_CODE (op) == ASHIFTRT || GET_CODE (op) == LSHIFTRT || GET_CODE (op) == ROTATERT) && (
#line 441 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(!CONST_INT_P (XEXP (op, 1))
			      || (UINTVAL (XEXP (op, 1))) < 32)))) && (
#line 443 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op)));
}

bool
sat_shift_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (((GET_CODE (op) == MULT) && (
#line 448 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(power_of_two_operand (XEXP (op, 1), mode)))) || ((GET_CODE (op) == ASHIFT || GET_CODE (op) == ASHIFTRT) && (
#line 450 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(CONST_INT_P (XEXP (op, 1))
		              && (UINTVAL (XEXP (op, 1)) < 32))))) && (
#line 452 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op)));
}

bool
long_shift_imm (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 456 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Pg (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
arm_reg_or_long_shift_imm (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((
#line 459 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_THUMB2
		    && arm_general_register_operand (op, GET_MODE (op)))) || (
#line 461 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Pg (op)))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

bool
mult_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return GET_CODE (op) == MULT;
}

bool
thumb_16bit_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case PLUS:
    case MINUS:
    case AND:
    case IOR:
    case XOR:
      return true;
    default:
      break;
    }
  return false;
}

bool
equality_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case EQ:
    case NE:
      return true;
    default:
      break;
    }
  return false;
}

bool
expandable_comparison_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case EQ:
    case NE:
    case LE:
    case LT:
    case GE:
    case GT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNLT:
    case UNLE:
    case UNGE:
    case UNGT:
      return true;
    default:
      break;
    }
  return false;
}

bool
arm_comparison_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (expandable_comparison_operator (op, mode)) && (
#line 485 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(maybe_get_arm_condition_code (op) != ARM_NV));
}

bool
arm_comparison_operator_mode (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((expandable_comparison_operator (op, mode)) && (
#line 492 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(maybe_get_arm_condition_code (op) != ARM_NV))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

static inline bool
arm_comparison_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 497 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (XEXP (op, 1) != const0_rtx)
    return false;
  rtx op0 = XEXP (op, 0);
  if (!REG_P (op0) || REGNO (op0) != CC_REGNUM)
    return false;
  return maybe_get_arm_condition_code (op) != ARM_NV;
}

bool
arm_comparison_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case EQ:
    case NE:
    case LE:
    case LT:
    case GE:
    case GT:
    case GEU:
    case GTU:
    case LEU:
    case LTU:
    case UNORDERED:
    case ORDERED:
    case UNLT:
    case UNLE:
    case UNGE:
    case UNGT:
      break;
    default:
      return false;
    }
  return 
(arm_comparison_operation_1 (op, mode));
}

bool
lt_ge_comparison_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case LT:
    case GE:
      return true;
    default:
      break;
    }
  return false;
}

static inline bool
arm_carry_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 511 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
    if (XEXP (op, 1) != const0_rtx)
      return false;

    rtx op0 = XEXP (op, 0);

    if (!REG_P (op0) || REGNO (op0) != CC_REGNUM)
      return false;

    machine_mode ccmode = GET_MODE (op0);
    if (ccmode == CC_Cmode)
      return GET_CODE (op) == LTU;
    else if (ccmode == CCmode || ccmode == CC_RSBmode || ccmode == CC_ADCmode)
      return GET_CODE (op) == GEU;

    return false;
  }

bool
arm_carry_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case GEU:
    case LTU:
      break;
    default:
      return false;
    }
  return 
(arm_carry_operation_1 (op, mode));
}

static inline bool
arm_borrow_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 536 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
    if (XEXP (op, 1) != const0_rtx)
      return false;
    rtx op0 = XEXP (op, 0);
    if (!REG_P (op0) || REGNO (op0) != CC_REGNUM)
      return false;
    machine_mode ccmode = GET_MODE (op0);
    if (ccmode == CC_Cmode)
      return GET_CODE (op) == GEU;
    else if (ccmode == CCmode || ccmode == CC_RSBmode || ccmode == CC_ADCmode)
      return GET_CODE (op) == LTU;
    return false;
  }

bool
arm_borrow_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case GEU:
    case LTU:
      break;
    default:
      return false;
    }
  return 
(arm_borrow_operation_1 (op, mode));
}

bool
arm_vsel_comparison_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (expandable_comparison_operator (op, mode)) && (
#line 554 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(maybe_get_arm_condition_code (op) == ARM_GE
                    || maybe_get_arm_condition_code (op) == ARM_GT
                    || maybe_get_arm_condition_code (op) == ARM_EQ
                    || maybe_get_arm_condition_code (op) == ARM_VS
                    || maybe_get_arm_condition_code (op) == ARM_LT
                    || maybe_get_arm_condition_code (op) == ARM_LE
                    || maybe_get_arm_condition_code (op) == ARM_NE
                    || maybe_get_arm_condition_code (op) == ARM_VC));
}

bool
arm_cond_move_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 564 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_restrict_it)) ? ((
#line 565 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_VFP5)) && (arm_vsel_comparison_operator (op, mode))) : (expandable_comparison_operator (op, mode));
}

bool
nz_comparison_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case LT:
    case GE:
    case EQ:
    case NE:
      return true;
    default:
      break;
    }
  return false;
}

bool
minmax_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case SMIN:
    case SMAX:
    case UMIN:
    case UMAX:
      break;
    default:
      return false;
    }
  return 
#line 574 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op));
}

bool
cc_register (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == REG) && ((
#line 578 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(REGNO (op) == CC_REGNUM)) && ((
#line 579 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == GET_MODE (op))) || (
#line 580 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(mode == VOIDmode && GET_MODE_CLASS (GET_MODE (op)) == MODE_CC))));
}

static inline bool
dominant_cc_register_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 584 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (mode == VOIDmode)
    {
      mode = GET_MODE (op);
      
      if (GET_MODE_CLASS (mode) != MODE_CC)
	return false;
    }

  return (cc_register (op, mode)
	  && (mode == CC_DNEmode
	     || mode == CC_DEQmode
	     || mode == CC_DLEmode
	     || mode == CC_DLTmode
	     || mode == CC_DGEmode
	     || mode == CC_DGTmode
	     || mode == CC_DLEUmode
	     || mode == CC_DLTUmode
	     || mode == CC_DGEUmode
	     || mode == CC_DGTUmode));
}

bool
dominant_cc_register (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == REG) && (
(dominant_cc_register_1 (op, mode)));
}

bool
cc_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == REG) && ((s_register_operand (op, mode)) || (cc_register (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
arm_extendqisi_mem_op (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (memory_operand (op, mode)) && (
#line 614 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_ARM ? arm_legitimate_address_outer_p (mode,
                                                                 XEXP (op, 0),
						                 SIGN_EXTEND,
								 0)
                               : memory_address_p (QImode, XEXP (op, 0))));
}

bool
arm_reg_or_extendqisi_mem_op (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (arm_extendqisi_mem_op (op, mode)) || (s_register_operand (op, mode));
}

static inline bool
power_of_two_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 626 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  unsigned HOST_WIDE_INT value = INTVAL (op) & 0xffffffff;

  return value != 0 && (value & (value - 1)) == 0;
}

bool
power_of_two_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
(power_of_two_operand_1 (op, mode)));
}

static inline bool
nonimmediate_di_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 634 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
   if (s_register_operand (op, mode))
     return true;

   if (GET_CODE (op) == SUBREG)
     op = SUBREG_REG (op);

   return MEM_P (op) && memory_address_p (DImode, XEXP (op, 0));
}

bool
nonimmediate_di_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
    case MEM:
      break;
    default:
      return false;
    }
  return (
(nonimmediate_di_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
di_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_INT || GET_CODE (op) == CONST_DOUBLE) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode))) || ((GET_CODE (op) == REG || GET_CODE (op) == SUBREG || GET_CODE (op) == MEM) && (nonimmediate_di_operand (op, mode)));
}

static inline bool
nonimmediate_soft_df_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 651 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if (s_register_operand (op, mode))
    return true;

  if (GET_CODE (op) == SUBREG)
    op = SUBREG_REG (op);

  return MEM_P (op) && memory_address_p (DFmode, XEXP (op, 0));
}

bool
nonimmediate_soft_df_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
    case MEM:
      break;
    default:
      return false;
    }
  return (
(nonimmediate_soft_df_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
soft_df_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_DOUBLE) && (
(mode == VOIDmode || GET_MODE (op) == mode))) || ((GET_CODE (op) == REG || GET_CODE (op) == SUBREG || GET_CODE (op) == MEM) && (nonimmediate_soft_df_operand (op, mode)));
}

bool
hard_sf_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (general_operand (op, mode)) && ((!(GET_CODE (op) == CONST_DOUBLE)) || ((!(
#line 671 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_disable_literal_pool))) || (
#line 672 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Dv (op)))));
}

bool
hard_df_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (soft_df_operand (op, mode)) && ((!(GET_CODE (op) == CONST_DOUBLE)) || ((!(
#line 680 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_disable_literal_pool))) || ((
#line 681 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_Dy (op))) || (
#line 682 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(satisfies_constraint_G (op))))));
}

static inline bool
clear_multiple_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 686 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
 return clear_operation_p (op, /*vfp*/false);
}

bool
clear_multiple_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(clear_multiple_operation_1 (op, mode)));
}

static inline bool
clear_vfp_multiple_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 692 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
 return clear_operation_p (op, /*vfp*/true);
}

bool
clear_vfp_multiple_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(clear_vfp_multiple_operation_1 (op, mode)));
}

static inline bool
load_multiple_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 698 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
 return ldm_stm_operation_p (op, /*load=*/true, SImode,
                                 /*consecutive=*/false,
                                 /*return_pc=*/false);
}

bool
load_multiple_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(load_multiple_operation_1 (op, mode)));
}

static inline bool
store_multiple_operation_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 706 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
 return ldm_stm_operation_p (op, /*load=*/false, SImode,
                                 /*consecutive=*/false,
                                 /*return_pc=*/false);
}

bool
store_multiple_operation (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(store_multiple_operation_1 (op, mode)));
}

static inline bool
pop_multiple_return_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 714 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
 return ldm_stm_operation_p (op, /*load=*/true, SImode,
                                 /*consecutive=*/false,
                                 /*return_pc=*/true);
}

bool
pop_multiple_return (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(pop_multiple_return_1 (op, mode)));
}

static inline bool
pop_multiple_fp_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 722 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
 return ldm_stm_operation_p (op, /*load=*/true, DFmode,
                                 /*consecutive=*/true,
                                 /*return_pc=*/false);
}

bool
pop_multiple_fp (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(pop_multiple_fp_1 (op, mode)));
}

static inline bool
multi_register_push_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 730 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  if ((GET_CODE (XVECEXP (op, 0, 0)) != SET)
      || (GET_CODE (SET_SRC (XVECEXP (op, 0, 0))) != UNSPEC)
      || (XINT (SET_SRC (XVECEXP (op, 0, 0)), 1) != UNSPEC_PUSH_MULT))
    return false;

  return true;
}

bool
multi_register_push (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(multi_register_push_1 (op, mode)));
}

static inline bool
push_mult_memory_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 741 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  /* ??? Given how PUSH_MULT is generated in the prologues, is there
     any point in testing for thumb1 specially?  All of the variants
     use the same form.  */
  if (TARGET_THUMB1)
    {
      /* ??? No attempt is made to represent STMIA, or validate that
	 the stack adjustment matches the register count.  This is
	 true of the ARM/Thumb2 path as well.  */
      rtx x = XEXP (op, 0);
      if (GET_CODE (x) != PRE_MODIFY)
	return false;
      if (XEXP (x, 0) != stack_pointer_rtx)
	return false;
      x = XEXP (x, 1);
      if (GET_CODE (x) != PLUS)
	return false;
      if (XEXP (x, 0) != stack_pointer_rtx)
	return false;
      return CONST_INT_P (XEXP (x, 1));
    }

  /* ARM and Thumb2 handle pre-modify in their legitimate_address.  */
  return memory_operand (op, mode);
}

bool
push_mult_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
(push_mult_memory_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
thumb1_cmp_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == REG || GET_CODE (op) == SUBREG) && (s_register_operand (op, mode))) || (((GET_CODE (op) == CONST_INT) && (
#line 776 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
((UINTVAL (op)) < 256))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode)));
}

bool
thumb1_cmpneg_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
#line 780 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(INTVAL (op) < 0 && INTVAL (op) > -256));
}

bool
thumb_cbrch_target_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case REG:
    case SUBREG:
    case MEM:
      break;
    default:
      return false;
    }
  return (s_register_operand (op, mode)) || ((
#line 794 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(reload_in_progress || reload_completed)) && (memory_operand (op, mode)));
}

bool
imm_or_reg_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (immediate_operand (op, mode)) || (register_operand (op, mode));
}

static inline bool
const_multiple_of_8_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 810 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  unsigned HOST_WIDE_INT val = INTVAL (op);
  return (val & 7) == 0;
}

bool
const_multiple_of_8_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == CONST_INT) && (
(const_multiple_of_8_operand_1 (op, mode)));
}

static inline bool
imm_for_neon_mov_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 817 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return simd_immediate_valid_for_move (op, mode, NULL, NULL);
}

bool
imm_for_neon_mov_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  switch (GET_CODE (op))
    {
    case CONST_VECTOR:
    case CONST_INT:
      break;
    default:
      return false;
    }
  return (
(imm_for_neon_mov_operand_1 (op, mode))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

static inline bool
imm_for_neon_lshift_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 823 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return neon_immediate_valid_for_shift (op, mode, NULL, NULL, true);
}

bool
imm_for_neon_lshift_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_VECTOR) && (
(imm_for_neon_lshift_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

static inline bool
imm_for_neon_rshift_operand_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 829 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return neon_immediate_valid_for_shift (op, mode, NULL, NULL, false);
}

bool
imm_for_neon_rshift_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_VECTOR) && (
(imm_for_neon_rshift_operand_1 (op, mode)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
imm_lshift_or_reg_neon (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (imm_for_neon_lshift_operand (op, mode));
}

bool
imm_rshift_or_reg_neon (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (s_register_operand (op, mode)) || (imm_for_neon_rshift_operand (op, mode));
}

bool
cmpdi_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 844 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_32BIT)) && (arm_di_operand (op, mode));
}

bool
arm_sync_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (memory_operand (op, mode)) && (GET_CODE (XEXP (op, 0)) == REG);
}

bool
arm_ldrd_memory_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (
#line 854 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(arm_ldrd_legitimate_address (op))) && (
(mode == VOIDmode || GET_MODE (op) == mode || GET_MODE (op) == VOIDmode));
}

static inline bool
vect_par_constant_high_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 859 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return arm_simd_check_vect_par_cnst_half_p (op, mode, true);
}

bool
vect_par_constant_high (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(vect_par_constant_high_1 (op, mode)));
}

static inline bool
vect_par_constant_low_1 (rtx op ATTRIBUTE_UNUSED, machine_mode mode ATTRIBUTE_UNUSED)
#line 865 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
{
  return arm_simd_check_vect_par_cnst_half_p (op, mode, false);
}

bool
vect_par_constant_low (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (GET_CODE (op) == PARALLEL) && (
(vect_par_constant_low_1 (op, mode)));
}

bool
const_double_vcvt_power_of_two_reciprocal (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_DOUBLE) && (
#line 871 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_32BIT
		    && vfp3_const_double_for_fract_bits (op)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
const_double_vcvt_power_of_two (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == CONST_DOUBLE) && (
#line 876 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_32BIT
		    && vfp3_const_double_for_bits (op) > 0))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
neon_struct_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
#line 881 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_32BIT && neon_vector_mem_operand (op, 2, true)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
mve_struct_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
#line 885 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_HAVE_MVE && mve_struct_mem_operand (op)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
neon_permissive_struct_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (
#line 889 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(TARGET_32BIT && neon_vector_mem_operand (op, 2, false)))) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
neon_perm_struct_or_reg_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (neon_permissive_struct_operand (op, mode)) || (s_register_operand (op, mode));
}

bool
add_operator (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return GET_CODE (op) == PLUS;
}

bool
mem_noofs_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return ((GET_CODE (op) == MEM) && (GET_CODE (XEXP (op, 0)) == REG)) && (
(mode == VOIDmode || GET_MODE (op) == mode));
}

bool
call_insn_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (((GET_CODE (op) == SYMBOL_REF) && (
#line 904 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(!arm_is_long_call_p (SYMBOL_REF_DECL (op))))) && (
(mode == VOIDmode || GET_MODE (op) == mode))) || (s_register_operand (op, mode));
}

bool
aligned_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (!(GET_CODE (op) == MEM)) || (
#line 909 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(MEM_ALIGN (op) >= GET_MODE_ALIGNMENT (mode)));
}

bool
arm_any_register_operand (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return GET_CODE (op) == REG;
}

bool
mem_and_no_t1_wback_op (rtx op, machine_mode mode ATTRIBUTE_UNUSED)
{
  return (memory_operand (op, mode)) && (
#line 918 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/predicates.md"
(!(TARGET_THUMB1 && GET_CODE (XEXP (op, 0)) == POST_INC)));
}

enum constraint_num
lookup_constraint_1 (const char *str)
{
  switch (str[0])
    {
    case '<':
      return CONSTRAINT__l;
    case '>':
      return CONSTRAINT__g;
    case 'C':
      if (str[1] == 's')
        return CONSTRAINT_Cs;
      break;
    case 'D':
      if (str[1] == 'B')
        return CONSTRAINT_DB;
      if (str[1] == 'a')
        return CONSTRAINT_Da;
      if (str[1] == 'b')
        return CONSTRAINT_Db;
      if (str[1] == 'c')
        return CONSTRAINT_Dc;
      if (str[1] == 'd')
        return CONSTRAINT_Dd;
      if (str[1] == 'i')
        return CONSTRAINT_Di;
      if (str[1] == 'j')
        return CONSTRAINT_Dj;
      if (str[1] == 'm')
        return CONSTRAINT_Dm;
      if (str[1] == 'n')
        return CONSTRAINT_Dn;
      if (str[1] == 'N')
        return CONSTRAINT_DN;
      if (str[1] == 'l')
        return CONSTRAINT_Dl;
      if (str[1] == 'L')
        return CONSTRAINT_DL;
      if (str[1] == 'o')
        return CONSTRAINT_Do;
      if (str[1] == 'v')
        return CONSTRAINT_Dv;
      if (str[1] == 'y')
        return CONSTRAINT_Dy;
      if (str[1] == 't')
        return CONSTRAINT_Dt;
      if (str[1] == 's')
        return CONSTRAINT_Ds;
      if (str[1] == 'p')
        return CONSTRAINT_Dp;
      if (str[1] == 'z')
        return CONSTRAINT_Dz;
      break;
    case 'E':
      return CONSTRAINT_E;
    case 'F':
      return CONSTRAINT_F;
    case 'G':
      return CONSTRAINT_G;
    case 'H':
      if (str[1] == 'a')
        return CONSTRAINT_Ha;
      break;
    case 'I':
      return CONSTRAINT_I;
    case 'J':
      return CONSTRAINT_J;
    case 'K':
      return CONSTRAINT_K;
    case 'L':
      return CONSTRAINT_L;
    case 'M':
      return CONSTRAINT_M;
    case 'N':
      return CONSTRAINT_N;
    case 'O':
      return CONSTRAINT_O;
    case 'P':
      if (str[1] == 'J')
        return CONSTRAINT_PJ;
      if (str[1] == 'a')
        return CONSTRAINT_Pa;
      if (str[1] == 'b')
        return CONSTRAINT_Pb;
      if (str[1] == 'c')
        return CONSTRAINT_Pc;
      if (str[1] == 'd')
        return CONSTRAINT_Pd;
      if (str[1] == 'e')
        return CONSTRAINT_Pe;
      if (str[1] == 'g')
        return CONSTRAINT_Pg;
      if (str[1] == 's')
        return CONSTRAINT_Ps;
      if (str[1] == 't')
        return CONSTRAINT_Pt;
      if (str[1] == 'u')
        return CONSTRAINT_Pu;
      if (str[1] == 'v')
        return CONSTRAINT_Pv;
      if (str[1] == 'w')
        return CONSTRAINT_Pw;
      if (str[1] == 'x')
        return CONSTRAINT_Px;
      if (str[1] == 'y')
        return CONSTRAINT_Py;
      if (str[1] == 'z')
        return CONSTRAINT_Pz;
      if (str[1] == 'j')
        return CONSTRAINT_Pj;
      break;
    case 'Q':
      return CONSTRAINT_Q;
    case 'R':
      if (str[1] == 'a')
        return CONSTRAINT_Ra;
      if (str[1] == 'b')
        return CONSTRAINT_Rb;
      if (str[1] == 'c')
        return CONSTRAINT_Rc;
      if (str[1] == 'e')
        return CONSTRAINT_Re;
      if (str[1] == 'f')
        return CONSTRAINT_Rf;
      if (str[1] == 'g')
        return CONSTRAINT_Rg;
      if (str[1] == 'i')
        return CONSTRAINT_Ri;
      if (str[1] == 'l')
        return CONSTRAINT_Rl;
      if (str[1] == 'd')
        return CONSTRAINT_Rd;
      break;
    case 'T':
      if (str[1] == 'u')
        return CONSTRAINT_Tu;
      if (str[1] == 's')
        return CONSTRAINT_Ts;
      if (str[1] == 'e')
        return CONSTRAINT_Te;
      break;
    case 'U':
      if (str[1] == 'l')
        return CONSTRAINT_Ul;
      if (str[1] == 'f')
        return CONSTRAINT_Uf;
      if (str[1] == 'a')
        return CONSTRAINT_Ua;
      if (str[1] == 'h')
        return CONSTRAINT_Uh;
      if (str[1] == 't')
        return CONSTRAINT_Ut;
      if (str[1] == 'v')
        return CONSTRAINT_Uv;
      if (str[1] == 'g')
        return CONSTRAINT_Ug;
      if (str[1] == 'j')
        return CONSTRAINT_Uj;
      if (str[1] == 'y')
        return CONSTRAINT_Uy;
      if (str[1] == 'n')
        return CONSTRAINT_Un;
      if (str[1] == 'm')
        return CONSTRAINT_Um;
      if (str[1] == 's')
        return CONSTRAINT_Us;
      if (str[1] == 'x')
        return CONSTRAINT_Ux;
      if (str[1] == 'i')
        return CONSTRAINT_Ui;
      if (str[1] == 'q')
        return CONSTRAINT_Uq;
      if (str[1] == 'u')
        return CONSTRAINT_Uu;
      if (str[1] == 'w')
        return CONSTRAINT_Uw;
      if (str[1] == 'S')
        return CONSTRAINT_US;
      if (str[1] == 'z')
        return CONSTRAINT_Uz;
      if (str[1] == 'o')
        return CONSTRAINT_Uo;
      if (str[1] == 'p')
        return CONSTRAINT_Up;
      break;
    case 'V':
      return CONSTRAINT_V;
    case 'X':
      return CONSTRAINT_X;
    case 'b':
      return CONSTRAINT_b;
    case 'c':
      return CONSTRAINT_c;
    case 'h':
      return CONSTRAINT_h;
    case 'i':
      return CONSTRAINT_i;
    case 'j':
      return CONSTRAINT_j;
    case 'k':
      return CONSTRAINT_k;
    case 'l':
      return CONSTRAINT_l;
    case 'm':
      return CONSTRAINT_m;
    case 'n':
      return CONSTRAINT_n;
    case 'o':
      return CONSTRAINT_o;
    case 'p':
      return CONSTRAINT_p;
    case 'r':
      return CONSTRAINT_r;
    case 's':
      return CONSTRAINT_s;
    case 't':
      return CONSTRAINT_t;
    case 'w':
      return CONSTRAINT_w;
    case 'x':
      return CONSTRAINT_x;
    case 'y':
      return CONSTRAINT_y;
    case 'z':
      return CONSTRAINT_z;
    default: break;
    }
  return CONSTRAINT__UNKNOWN;
}

const unsigned char lookup_constraint_array[] = {
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT__l, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT__g, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  UCHAR_MAX,
  UCHAR_MAX,
  MIN ((int) CONSTRAINT_E, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_F, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_G, (int) UCHAR_MAX),
  UCHAR_MAX,
  MIN ((int) CONSTRAINT_I, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_J, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_K, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_L, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_M, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_N, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_O, (int) UCHAR_MAX),
  UCHAR_MAX,
  MIN ((int) CONSTRAINT_Q, (int) UCHAR_MAX),
  UCHAR_MAX,
  CONSTRAINT__UNKNOWN,
  UCHAR_MAX,
  UCHAR_MAX,
  MIN ((int) CONSTRAINT_V, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT_X, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT_b, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_c, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT_h, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_i, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_j, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_k, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_l, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_m, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_n, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_o, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_p, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT_r, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_s, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_t, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  MIN ((int) CONSTRAINT_w, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_x, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_y, (int) UCHAR_MAX),
  MIN ((int) CONSTRAINT_z, (int) UCHAR_MAX),
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN,
  CONSTRAINT__UNKNOWN
};

enum reg_class
reg_class_for_constraint_1 (enum constraint_num c)
{
  switch (c)
    {
    case CONSTRAINT_r: return GENERAL_REGS;
    case CONSTRAINT_Up: return TARGET_HAVE_MVE ? VPR_REG : NO_REGS;
    case CONSTRAINT_Uf: return TARGET_HAVE_MVE ? VFPCC_REG : NO_REGS;
    case CONSTRAINT_Te: return TARGET_HAVE_MVE ? EVEN_REG : NO_REGS;
    case CONSTRAINT_t: return TARGET_32BIT ? VFP_LO_REGS : NO_REGS;
    case CONSTRAINT_w: return TARGET_32BIT ? (TARGET_VFPD32 ? VFP_REGS : VFP_LO_REGS) : NO_REGS;
    case CONSTRAINT_x: return TARGET_32BIT ? VFP_D0_D7_REGS : NO_REGS;
    case CONSTRAINT_y: return TARGET_REALLY_IWMMXT ? IWMMXT_REGS : NO_REGS;
    case CONSTRAINT_z: return TARGET_REALLY_IWMMXT ? IWMMXT_GR_REGS : NO_REGS;
    case CONSTRAINT_l: return TARGET_THUMB ? LO_REGS : GENERAL_REGS;
    case CONSTRAINT_h: return TARGET_THUMB ? HI_REGS : NO_REGS;
    case CONSTRAINT_k: return STACK_REG;
    case CONSTRAINT_b: return TARGET_THUMB ? BASE_REGS : NO_REGS;
    case CONSTRAINT_Cs: return CALLER_SAVE_REGS;
    case CONSTRAINT_Ts: return (arm_restrict_it) ? LO_REGS : GENERAL_REGS;
    default: break;
    }
  return NO_REGS;
}

bool (*constraint_satisfied_p_array[]) (rtx) = {
  satisfies_constraint_Pj,
  satisfies_constraint_PJ,
  satisfies_constraint_I,
  satisfies_constraint_J,
  satisfies_constraint_K,
  satisfies_constraint_L,
  satisfies_constraint_M,
  satisfies_constraint_N,
  satisfies_constraint_O,
  satisfies_constraint_Pa,
  satisfies_constraint_Pb,
  satisfies_constraint_Pc,
  satisfies_constraint_Pd,
  satisfies_constraint_Pe,
  satisfies_constraint_Pg,
  satisfies_constraint_Ps,
  satisfies_constraint_Pt,
  satisfies_constraint_Pu,
  satisfies_constraint_Pv,
  satisfies_constraint_Pw,
  satisfies_constraint_Px,
  satisfies_constraint_Py,
  satisfies_constraint_Pz,
  satisfies_constraint_m,
  satisfies_constraint_o,
  satisfies_constraint_Ul,
  satisfies_constraint_Ua,
  satisfies_constraint_Uh,
  satisfies_constraint_Ut,
  satisfies_constraint_Uv,
  satisfies_constraint_Ug,
  satisfies_constraint_Uj,
  satisfies_constraint_Uy,
  satisfies_constraint_Un,
  satisfies_constraint_Um,
  satisfies_constraint_Us,
  satisfies_constraint_Ux,
  satisfies_constraint_Uq,
  satisfies_constraint_Q,
  satisfies_constraint_Uu,
  satisfies_constraint_Uw,
  satisfies_constraint_Uz,
  satisfies_constraint_Uo,
  satisfies_constraint_p,
  satisfies_constraint_Rd,
  satisfies_constraint_Ra,
  satisfies_constraint_Rb,
  satisfies_constraint_Rc,
  satisfies_constraint_Re,
  satisfies_constraint_Rf,
  satisfies_constraint_Rg,
  satisfies_constraint_j,
  satisfies_constraint_G,
  satisfies_constraint_Ha,
  satisfies_constraint_Dz,
  satisfies_constraint_DB,
  satisfies_constraint_Da,
  satisfies_constraint_Db,
  satisfies_constraint_Dc,
  satisfies_constraint_Dd,
  satisfies_constraint_Di,
  satisfies_constraint_Dj,
  satisfies_constraint_Dm,
  satisfies_constraint_Dn,
  satisfies_constraint_DN,
  satisfies_constraint_Dl,
  satisfies_constraint_DL,
  satisfies_constraint_Do,
  satisfies_constraint_Dv,
  satisfies_constraint_Dy,
  satisfies_constraint_Dt,
  satisfies_constraint_Ds,
  satisfies_constraint_Dp,
  satisfies_constraint_US,
  satisfies_constraint_Ri,
  satisfies_constraint_Rl,
  satisfies_constraint_c,
  satisfies_constraint_V,
  satisfies_constraint__l,
  satisfies_constraint__g,
  satisfies_constraint_i,
  satisfies_constraint_s,
  satisfies_constraint_n,
  satisfies_constraint_E,
  satisfies_constraint_F,
  satisfies_constraint_X,
  satisfies_constraint_Tu,
  satisfies_constraint_Ui
};

bool
insn_const_int_ok_for_constraint (HOST_WIDE_INT ival, enum constraint_num c)
{
  switch (c)
    {
    case CONSTRAINT_Pj:
      return (
#line 139 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2)) && (
#line 140 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
((ival & 0xfffff000) == 0));

    case CONSTRAINT_PJ:
      return (
#line 145 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2)) && (
#line 146 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(((-ival) & 0xfffff000) == 0));

    case CONSTRAINT_I:
      return 
#line 167 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_32BIT ? const_ok_for_arm (ival)
		   : ival >= 0 && ival <= 255);

    case CONSTRAINT_J:
      return 
#line 174 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_32BIT ? (ival >= -4095 && ival <= 4095)
		   : (ival >= -255 && ival <= -1));

    case CONSTRAINT_K:
      return 
#line 182 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_32BIT ? const_ok_for_arm (~ival)
		   : thumb_shiftable_const (ival));

    case CONSTRAINT_L:
      return 
#line 189 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_32BIT ? const_ok_for_arm (-ival)
		   : (ival >= -7 && ival <= 7));

    case CONSTRAINT_M:
      return 
#line 198 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_32BIT ? ((ival >= 0 && ival <= 32)
				 || (((ival & (ival - 1)) & 0xFFFFFFFF) == 0))
		   : ival >= 0 && ival <= 1020 && (ival & 3) == 0);

    case CONSTRAINT_N:
      return 
#line 205 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(!TARGET_32BIT && (ival >= 0 && ival <= 31));

    case CONSTRAINT_O:
      return 
#line 211 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB1 && ival >= -508 && ival <= 508
		   && ((ival & 3) == 0));

    case CONSTRAINT_Pa:
      return 
#line 217 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB1 && ival >= -510 && ival <= 510
		    && (ival > 255 || ival < -255));

    case CONSTRAINT_Pb:
      return 
#line 223 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB1 && ival >= -262 && ival <= 262
		    && (ival > 255 || ival < -255));

    case CONSTRAINT_Pc:
      return 
#line 229 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB1
  		    && ival > 1020 && ival <= 1275);

    case CONSTRAINT_Pd:
      return 
#line 235 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB && ival >= 0 && ival <= 7);

    case CONSTRAINT_Pe:
      return 
#line 240 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB1 && ival >= 256 && ival <= 510);

    case CONSTRAINT_Pg:
      return 
#line 245 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= 1 && ival <= 32);

    case CONSTRAINT_Ps:
      return 
#line 250 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= -255 && ival <= 255);

    case CONSTRAINT_Pt:
      return 
#line 255 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= -7 && ival <= 7);

    case CONSTRAINT_Pu:
      return 
#line 260 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= 1 && ival <= 8);

    case CONSTRAINT_Pv:
      return 
#line 265 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= -255 && ival <= 0);

    case CONSTRAINT_Pw:
      return 
#line 270 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= -255 && ival <= -1);

    case CONSTRAINT_Px:
      return 
#line 275 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= -7 && ival <= -1);

    case CONSTRAINT_Py:
      return 
#line 280 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && ival >= 0 && ival <= 255);

    case CONSTRAINT_Pz:
      return 
#line 285 "/data/archarm-lib32/tmp/lib32-gcc/src/gcc/gcc/config/arm/constraints.md"
(TARGET_THUMB2 && (ival == 0));

    default: break;
    }
  return false;
}


void
init_reg_class_start_regs ()
{
}
